/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.util.FormatUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.PerfDataUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfCounterQueryHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterQueryHandler.class);
    private Map<PerfDataUtil.PerfCounter, ByRef.CloseableHANDLEByReference> counterHandleMap = new HashMap<PerfDataUtil.PerfCounter, ByRef.CloseableHANDLEByReference>();
    private ByRef.CloseableHANDLEByReference queryHandle = null;

    public boolean addCounterToQuery(PerfDataUtil.PerfCounter perfCounter) {
        if (this.queryHandle == null) {
            this.queryHandle = new ByRef.CloseableHANDLEByReference();
            if (!PerfDataUtil.openQuery(this.queryHandle)) {
                LOG.warn("Failed to open a query for PDH counter: {}", (Object)perfCounter.getCounterPath());
                this.queryHandle.close();
                this.queryHandle = null;
                return false;
            }
        }
        ByRef.CloseableHANDLEByReference closeableHANDLEByReference = new ByRef.CloseableHANDLEByReference();
        if (!PerfDataUtil.addCounter(this.queryHandle, perfCounter.getCounterPath(), closeableHANDLEByReference)) {
            LOG.warn("Failed to add counter for PDH counter: {}", (Object)perfCounter.getCounterPath());
            closeableHANDLEByReference.close();
            return false;
        }
        this.counterHandleMap.put(perfCounter, closeableHANDLEByReference);
        return true;
    }

    public void removeAllCounters() {
        for (ByRef.CloseableHANDLEByReference closeableHANDLEByReference : this.counterHandleMap.values()) {
            PerfDataUtil.removeCounter(closeableHANDLEByReference);
            closeableHANDLEByReference.close();
        }
        this.counterHandleMap.clear();
        if (this.queryHandle != null) {
            PerfDataUtil.closeQuery(this.queryHandle);
            this.queryHandle.close();
            this.queryHandle = null;
        }
    }

    public long updateQuery() {
        if (this.queryHandle == null) {
            LOG.warn("Query does not exist to update.");
            return 0L;
        }
        return PerfDataUtil.updateQueryTimestamp(this.queryHandle);
    }

    public long queryCounter(PerfDataUtil.PerfCounter perfCounter) {
        long l2;
        if (!this.counterHandleMap.containsKey(perfCounter)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Counter {} does not exist to query.", (Object)perfCounter.getCounterPath());
            }
            return 0L;
        }
        long l3 = l2 = perfCounter.isBaseCounter() ? PerfDataUtil.querySecondCounter(this.counterHandleMap.get(perfCounter)) : PerfDataUtil.queryCounter(this.counterHandleMap.get(perfCounter));
        if (l2 < 0L) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error querying counter {}: {}", (Object)perfCounter.getCounterPath(), (Object)String.format(Locale.ROOT, FormatUtil.formatError((int)l2), new Object[0]));
            }
            return 0L;
        }
        return l2;
    }

    @Override
    public void close() {
        this.removeAllCounters();
    }
}

