/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.gradle.cache.internal.filelock.FileLockOutcome;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockInfoSerializer;
import org.gradle.internal.file.RandomAccessFileInputStream;
import org.gradle.internal.file.RandomAccessFileOutputStream;

public class LockInfoAccess {
    private final LockInfoSerializer lockInfoSerializer = new LockInfoSerializer();
    private final long infoRegionPos;

    public LockInfoAccess(long l2) {
        this.infoRegionPos = l2;
    }

    public LockInfo readLockInfo(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() <= this.infoRegionPos) {
            return new LockInfo();
        }
        randomAccessFile.seek(this.infoRegionPos);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new RandomAccessFileInputStream(randomAccessFile)));
        byte by2 = dataInputStream.readByte();
        if (by2 != this.lockInfoSerializer.getVersion()) {
            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file. Expected %s, found %s.", this.lockInfoSerializer.getVersion(), by2));
        }
        return this.lockInfoSerializer.read(dataInputStream);
    }

    public void writeLockInfo(RandomAccessFile randomAccessFile, LockInfo lockInfo) throws IOException {
        randomAccessFile.seek(this.infoRegionPos);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new RandomAccessFileOutputStream(randomAccessFile)));
        dataOutputStream.writeByte(this.lockInfoSerializer.getVersion());
        this.lockInfoSerializer.write(dataOutputStream, lockInfo);
        dataOutputStream.flush();
        randomAccessFile.setLength(randomAccessFile.getFilePointer());
    }

    public void clearLockInfo(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.setLength(Math.min(randomAccessFile.length(), this.infoRegionPos));
    }

    public FileLockOutcome tryLock(RandomAccessFile randomAccessFile, boolean bl2) throws IOException {
        try {
            FileLock fileLock = randomAccessFile.getChannel().tryLock(this.infoRegionPos, 2052L - this.infoRegionPos, bl2);
            if (fileLock == null) {
                return FileLockOutcome.LOCKED_BY_ANOTHER_PROCESS;
            }
            return FileLockOutcome.acquired(fileLock);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return FileLockOutcome.LOCKED_BY_THIS_PROCESS;
        }
    }
}

