/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationListenerManager
implements BuildOperationListenerManager {
    private List<ProgressShieldingBuildOperationListener> listeners = Collections.emptyList();
    private final Lock listenersLock = new ReentrantLock();
    private final BuildOperationListener broadcaster = new BuildOperationListener(){

        @Override
        public void started(BuildOperationDescriptor buildOperationDescriptor, OperationStartEvent operationStartEvent) {
            List list = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((BuildOperationListener)list.get(i2)).started(buildOperationDescriptor, operationStartEvent);
            }
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent operationProgressEvent) {
            List list = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((BuildOperationListener)list.get(i2)).progress(operationIdentifier, operationProgressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperationDescriptor, OperationFinishEvent operationFinishEvent) {
            List list = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                ((BuildOperationListener)list.get(i2)).finished(buildOperationDescriptor, operationFinishEvent);
            }
        }
    };

    @Override
    public void addListener(BuildOperationListener buildOperationListener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> arrayList = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            arrayList.add(new ProgressShieldingBuildOperationListener(buildOperationListener));
            this.listeners = arrayList;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BuildOperationListener buildOperationListener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> arrayList = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                if (!((ProgressShieldingBuildOperationListener)listIterator.next()).delegate.equals(buildOperationListener)) continue;
                listIterator.remove();
            }
            this.listeners = arrayList;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    @Override
    public BuildOperationListener getBroadcaster() {
        return this.broadcaster;
    }

    private static class ProgressShieldingBuildOperationListener
    implements BuildOperationListener {
        private final Map<OperationIdentifier, Boolean> active = new ConcurrentHashMap<OperationIdentifier, Boolean>();
        private final BuildOperationListener delegate;

        private ProgressShieldingBuildOperationListener(BuildOperationListener buildOperationListener) {
            this.delegate = buildOperationListener;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperationDescriptor, OperationStartEvent operationStartEvent) {
            this.active.put(buildOperationDescriptor.getId(), Boolean.TRUE);
            this.delegate.started(buildOperationDescriptor, operationStartEvent);
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent operationProgressEvent) {
            if (this.active.containsKey(operationIdentifier)) {
                this.delegate.progress(operationIdentifier, operationProgressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperationDescriptor, OperationFinishEvent operationFinishEvent) {
            this.active.remove(buildOperationDescriptor.getId());
            this.delegate.finished(buildOperationDescriptor, operationFinishEvent);
        }
    }
}

