/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.driver.textui.Debug;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.ElementDeclExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.IdentityConstraint;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.KeyRefConstraint;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.LightStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Acceptor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ErrorInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ValidityViolation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.KeyValue;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.Matcher;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.SelectorMatcher;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.xmlschema.XSREDocDecl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IDConstraintChecker
extends Verifier {
    protected final XMLSchemaGrammar grammar;
    protected final Vector<Matcher> matchers = new Vector();
    private final Map<SelectorMatcher, Set<Object>> keyValues = new HashMap<SelectorMatcher, Set<Object>>();
    private final Map<SelectorMatcher, SelectorMatcher> referenceScope = new HashMap<SelectorMatcher, SelectorMatcher>();
    private final Map<IdentityConstraint, LightStack> activeScopes = new HashMap<IdentityConstraint, LightStack>();
    public static final String ERR_UNMATCHED_KEY_FIELD = "IdentityConstraint.UnmatchedKeyField";
    public static final String ERR_NOT_UNIQUE = "IdentityConstraint.NotUnique";
    public static final String ERR_NOT_UNIQUE_DIAG = "IdentityConstraint.NotUnique.Diag";
    public static final String ERR_DOUBLE_MATCH = "IdentityConstraint.DoubleMatch";
    public static final String ERR_UNDEFINED_KEY = "IdentityConstraint.UndefinedKey";

    public IDConstraintChecker(XMLSchemaGrammar xMLSchemaGrammar, ErrorHandler errorHandler) {
        super(new XSREDocDecl(xMLSchemaGrammar), errorHandler);
        this.grammar = xMLSchemaGrammar;
    }

    protected void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    protected void remove(Matcher matcher) {
        this.matchers.remove(matcher);
    }

    protected SelectorMatcher getActiveScope(IdentityConstraint identityConstraint) {
        LightStack lightStack = this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            return null;
        }
        if (lightStack.size() == 0) {
            return null;
        }
        return (SelectorMatcher)lightStack.top();
    }

    protected void pushActiveScope(IdentityConstraint identityConstraint, SelectorMatcher selectorMatcher) {
        LightStack lightStack = this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            lightStack = new LightStack();
            this.activeScopes.put(identityConstraint, lightStack);
        }
        lightStack.push(selectorMatcher);
    }

    protected void popActiveScope(IdentityConstraint identityConstraint, SelectorMatcher selectorMatcher) {
        LightStack lightStack = this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            throw new Error();
        }
        if (lightStack.pop() != selectorMatcher) {
            throw new Error();
        }
    }

    protected boolean addKeyValue(SelectorMatcher selectorMatcher, KeyValue keyValue) {
        Set<Object> set = this.keyValues.get(selectorMatcher);
        if (set == null) {
            set = new HashSet<Object>();
            this.keyValues.put(selectorMatcher, set);
        }
        return set.add(keyValue);
    }

    protected KeyValue[] getKeyValues(SelectorMatcher selectorMatcher) {
        Set<Object> set = this.keyValues.get(selectorMatcher);
        if (set == null) {
            return new KeyValue[0];
        }
        return set.toArray(new KeyValue[set.size()]);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.keyValues.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        Map.Entry[] entryArray = this.keyValues.entrySet().toArray(new Map.Entry[this.keyValues.size()]);
        if (Debug.debug) {
            System.out.println("key/keyref check: there are " + this.keyValues.size() + " scope(s)");
        }
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            SelectorMatcher selectorMatcher = (SelectorMatcher)entryArray[i2].getKey();
            Set set = (Set)entryArray[i2].getValue();
            if (!(selectorMatcher.idConst instanceof KeyRefConstraint)) continue;
            Set<Object> set2 = this.keyValues.get(this.referenceScope.get(selectorMatcher));
            KeyValue[] keyValueArray = set.toArray(new KeyValue[set.size()]);
            for (int i3 = 0; i3 < keyValueArray.length; ++i3) {
                if (set2 != null && set2.contains(keyValueArray[i3])) continue;
                this.reportError(keyValueArray[i3].locator, null, ERR_UNDEFINED_KEY, new Object[]{selectorMatcher.idConst.namespaceURI, selectorMatcher.idConst.localName});
            }
        }
    }

    @Override
    protected void onNextAcceptorReady(StartTagInfo startTagInfo, Acceptor acceptor) throws SAXException {
        Object object;
        int n2 = this.matchers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.matchers.get(i2);
            ((Matcher)object).startElement(startTagInfo.namespaceURI, startTagInfo.localName);
        }
        Object object2 = acceptor.getOwnerType();
        if (object2 instanceof ElementDeclExp.XSElementExp) {
            object = (ElementDeclExp.XSElementExp)object2;
            if (((ElementDeclExp.XSElementExp)object).identityConstraints != null) {
                int n3;
                int n4 = ((ElementDeclExp.XSElementExp)object).identityConstraints.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.add(new SelectorMatcher(this, (IdentityConstraint)((ElementDeclExp.XSElementExp)object).identityConstraints.get(n3), startTagInfo.namespaceURI, startTagInfo.localName));
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    IdentityConstraint identityConstraint = (IdentityConstraint)((ElementDeclExp.XSElementExp)object).identityConstraints.get(n3);
                    if (!(identityConstraint instanceof KeyRefConstraint)) continue;
                    SelectorMatcher selectorMatcher = this.getActiveScope(((KeyRefConstraint)identityConstraint).key);
                    if (selectorMatcher == null) {
                        // empty if block
                    }
                    this.referenceScope.put(this.getActiveScope(identityConstraint), selectorMatcher);
                }
            }
        }
    }

    @Override
    protected Datatype[] feedAttribute(Acceptor acceptor, String string, String string2, String string3, String string4) throws SAXException {
        Datatype[] datatypeArray = super.feedAttribute(acceptor, string, string2, string3, string4);
        int n2 = this.matchers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Matcher matcher = this.matchers.get(i2);
            matcher.onAttribute(string, string2, string4, datatypeArray == null || datatypeArray.length == 0 ? null : datatypeArray[0]);
        }
        return datatypeArray;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        super.characters(cArray, n2, n3);
        int n4 = this.matchers.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.matchers.get(i2).characters(cArray, n2, n3);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        Datatype[] datatypeArray = this.getLastCharacterType();
        Datatype datatype = datatypeArray == null || datatypeArray.length == 0 ? null : this.getLastCharacterType()[0];
        int n2 = this.matchers.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.matchers.get(i2).endElement(datatype);
        }
    }

    protected void reportError(ErrorInfo errorInfo, String string, Object[] objectArray) throws SAXException {
        this.reportError(this.getLocator(), errorInfo, string, objectArray);
    }

    protected void reportError(Locator locator, ErrorInfo errorInfo, String string, Object[] objectArray) throws SAXException {
        this.hadError = true;
        this.errorHandler.error(new ValidityViolation(locator, IDConstraintChecker.localizeMessage(string, objectArray), errorInfo));
    }

    public static String localizeMessage(String string, Object object) {
        return IDConstraintChecker.localizeMessage(string, new Object[]{object});
    }

    public static String localizeMessage(String string, Object[] objectArray) {
        String string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.Messages").getString(string);
        return MessageFormat.format(string2, objectArray);
    }
}

