/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.ContentReference;

public abstract class JsonStreamContext {
    protected int _type;
    protected int _index;
    protected int _nestingDepth;

    protected JsonStreamContext() {
    }

    protected JsonStreamContext(JsonStreamContext jsonStreamContext) {
        this._type = jsonStreamContext._type;
        this._index = jsonStreamContext._index;
    }

    protected JsonStreamContext(int n2, int n3) {
        this._type = n2;
        this._index = n3;
    }

    public abstract JsonStreamContext getParent();

    public final boolean inArray() {
        return this._type == 1;
    }

    public final boolean inRoot() {
        return this._type == 0;
    }

    public final boolean inObject() {
        return this._type == 2;
    }

    public final int getNestingDepth() {
        return this._nestingDepth;
    }

    public String typeDesc() {
        switch (this._type) {
            case 0: {
                return "root";
            }
            case 1: {
                return "Array";
            }
            case 2: {
                return "Object";
            }
        }
        return "?";
    }

    public final int getEntryCount() {
        return this._index + 1;
    }

    public final int getCurrentIndex() {
        return this._index < 0 ? 0 : this._index;
    }

    public boolean hasCurrentIndex() {
        return this._index >= 0;
    }

    public abstract String getCurrentName();

    public boolean hasCurrentName() {
        return this.getCurrentName() != null;
    }

    public Object getCurrentValue() {
        return null;
    }

    public void setCurrentValue(Object object) {
    }

    public JsonLocation startLocation(ContentReference contentReference) {
        return JsonLocation.NA;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            default: {
                stringBuilder.append('{');
                String string = this.getCurrentName();
                if (string != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, string);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

