/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.google.j2objc.annotations.RetainedWith;
import com.google.j2objc.annotations.Weak;
import com.gradle.maven.extension.internal.dep.com.google.common.base.MoreObjects;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.EmptyImmutableSetMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SetMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ImmutableSetMultimap<K, V>
extends ImmutableMultimap<K, V>
implements SetMultimap<K, V> {
    private final transient ImmutableSet<V> emptySet;
    @RetainedWith
    private transient ImmutableSet<Map.Entry<K, V>> entries;

    public static <K, V> ImmutableSetMultimap<K, V> of() {
        return EmptyImmutableSetMultimap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> ImmutableSetMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> collection, Comparator<? super V> comparator) {
        if (collection.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap.Builder<K, ImmutableSet<V>> builder = new ImmutableMap.Builder<K, ImmutableSet<V>>(collection.size());
        int n2 = 0;
        for (Map.Entry<K, Collection<V>> entry : collection) {
            K k2 = entry.getKey();
            Collection<? extends V> collection2 = entry.getValue();
            ImmutableSet<V> immutableSet = ImmutableSetMultimap.valueSet(comparator, collection2);
            if (immutableSet.isEmpty()) continue;
            builder.put(k2, immutableSet);
            n2 += immutableSet.size();
        }
        return new ImmutableSetMultimap(builder.buildOrThrow(), n2, comparator);
    }

    ImmutableSetMultimap(ImmutableMap<K, ImmutableSet<V>> immutableMap, int n2, Comparator<? super V> comparator) {
        super(immutableMap, n2);
        this.emptySet = ImmutableSetMultimap.emptySet(comparator);
    }

    @Override
    public ImmutableSet<V> get(K k2) {
        ImmutableSet immutableSet = (ImmutableSet)this.map.get(k2);
        return MoreObjects.firstNonNull(immutableSet, this.emptySet);
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entries() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entries;
        return immutableSet == null ? (this.entries = new EntrySet(this)) : immutableSet;
    }

    private static <V> ImmutableSet<V> valueSet(Comparator<? super V> comparator, Collection<? extends V> collection) {
        return comparator == null ? ImmutableSet.copyOf(collection) : ImmutableSortedSet.copyOf(comparator, collection);
    }

    private static <V> ImmutableSet<V> emptySet(Comparator<? super V> comparator) {
        return comparator == null ? ImmutableSet.of() : ImmutableSortedSet.emptySet(comparator);
    }

    private static final class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        @Weak
        private final transient ImmutableSetMultimap<K, V> multimap;

        EntrySet(ImmutableSetMultimap<K, V> immutableSetMultimap) {
            this.multimap = immutableSetMultimap;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        Collection<V> newMutableValueCollection() {
            return Platform.preservesInsertionOrderOnAddsSet();
        }

        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, Iterable<? extends V> iterable) {
            super.putAll(k2, iterable);
            return this;
        }

        @Override
        public ImmutableSetMultimap<K, V> build() {
            Collection collection = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                collection = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(collection);
            }
            return ImmutableSetMultimap.fromMapEntries(collection, this.valueComparator);
        }
    }
}

