/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.SuccessorsFunction;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteSink;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteSource;
import com.gradle.maven.extension.internal.dep.com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file) {
            File[] fileArray;
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                return Collections.unmodifiableList(Arrays.asList(fileArray));
            }
            return ImmutableList.of();
        }
    };

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... fileWriteModeArray) {
        return new FileByteSink(file, fileWriteModeArray);
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... fileWriteModeArray) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf(fileWriteModeArray);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            return "Files.asByteSink(" + this.file + ", " + this.modes + ")";
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return "Files.asByteSource(" + this.file + ")";
        }
    }
}

