/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.ShortsMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Shorts
extends ShortsMethodsForWeb {
    public static int hashCode(short s2) {
        return s2;
    }

    private static int indexOf(short[] sArray, short s2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (sArray[i2] != s2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(short[] sArray, short s2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (sArray[i2] != s2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Short> asList(short ... sArray) {
        if (sArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(sArray);
    }

    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements Serializable,
    RandomAccess {
        final short[] array;
        final int start;
        final int end;

        ShortArrayAsList(short[] sArray) {
            this(sArray, 0, sArray.length);
        }

        ShortArrayAsList(short[] sArray, int n2, int n3) {
            this.array = sArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Short && Shorts.indexOf(this.array, (Short)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.indexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.lastIndexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int n2, Short s2) {
            Preconditions.checkElementIndex(n2, this.size());
            short s3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(s2);
            return s3;
        }

        @Override
        public List<Short> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList shortArrayAsList = (ShortArrayAsList)object;
                int n2 = this.size();
                if (shortArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == shortArrayAsList.array[shortArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Shorts.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 6);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

