/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.DocletTag;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.type.TypeResolver;
import java.io.Serializable;
import java.util.List;

public class DefaultJavaType
implements JavaClass,
Serializable {
    protected final String name;
    protected String fullName;
    private int dimensions;
    private TypeResolver typeResolver;

    DefaultJavaType(String string, TypeResolver typeResolver) {
        this.name = string;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String string, String string2, int n2, TypeResolver typeResolver) {
        this.fullName = string;
        this.name = string2;
        this.dimensions = n2;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String string, int n2) {
        this.name = string;
        this.fullName = string;
        this.dimensions = n2;
    }

    DefaultJavaType(String string) {
        this(string, 0);
    }

    @Override
    public String getBinaryName() {
        return this.resolveRealClass().getBinaryName();
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder(this.resolveRealClass().getFullyQualifiedName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public JavaClass getComponentType() {
        return this.isArray() ? this.resolveRealClass() : null;
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedValue(JavaType javaType, List<JavaTypeVariable<D>> list) {
        String string = javaType.getValue();
        for (JavaTypeVariable<D> javaTypeVariable : list) {
            if (!javaTypeVariable.getName().equals(javaType.getValue())) continue;
            string = javaTypeVariable.getBounds().get(0).getValue();
            break;
        }
        return string;
    }

    protected static <D extends JavaGenericDeclaration> JavaTypeVariable<D> resolve(JavaType javaType, List<JavaTypeVariable<D>> list) {
        JavaTypeVariable<D> javaTypeVariable = null;
        for (JavaTypeVariable<D> javaTypeVariable2 : list) {
            if (!javaTypeVariable2.getName().equals(javaType.getValue())) continue;
            javaTypeVariable = javaTypeVariable2;
            break;
        }
        return javaTypeVariable;
    }

    protected boolean isResolved() {
        if (this.fullName == null && this.typeResolver != null) {
            this.fullName = this.typeResolver.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaType)) {
            return false;
        }
        JavaType javaType = (JavaType)object;
        return this.getFullyQualifiedName().equals(javaType.getFullyQualifiedName());
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    private JavaClass resolveRealClass() {
        JavaClass javaClass = null;
        String string = this.isResolved() ? this.fullName : this.name;
        javaClass = DefaultJavaType.isPrimitive(string) ? new DefaultJavaClass(string) : this.typeResolver.getJavaClass(string);
        return javaClass;
    }

    private static boolean isPrimitive(String string) {
        return "void".equals(string) || "boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string);
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder(this.getCanonicalName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    @Override
    public JavaSource getSource() {
        return this.resolveRealClass().getSource();
    }

    @Override
    public boolean isInterface() {
        return this.resolveRealClass().isInterface();
    }

    @Override
    public List<JavaAnnotation> getAnnotations() {
        return this.resolveRealClass().getAnnotations();
    }

    @Override
    public boolean isEnum() {
        return this.resolveRealClass().isEnum();
    }

    @Override
    public String getComment() {
        return this.resolveRealClass().getComment();
    }

    @Override
    public List<DocletTag> getTags() {
        return this.resolveRealClass().getTags();
    }

    @Override
    public boolean isAnnotation() {
        return this.resolveRealClass().isAnnotation();
    }

    @Override
    public JavaType getSuperClass() {
        return this.resolveRealClass().getSuperClass();
    }

    @Override
    public List<JavaType> getImplements() {
        return this.resolveRealClass().getImplements();
    }

    @Override
    public <D extends JavaGenericDeclaration> List<JavaTypeVariable<D>> getTypeParameters() {
        return this.resolveRealClass().getTypeParameters();
    }

    @Override
    public JavaSource getParentSource() {
        return this.resolveRealClass().getParentSource();
    }

    @Override
    public String getPackageName() {
        return this.resolveRealClass().getPackageName();
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.resolveRealClass().getMethods();
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.resolveRealClass().getConstructors();
    }

    @Override
    public List<JavaField> getFields() {
        return this.resolveRealClass().getFields();
    }

    @Override
    public JavaField getFieldByName(String string) {
        return this.resolveRealClass().getFieldByName(string);
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.resolveRealClass().getNestedClasses();
    }

    @Override
    public String getName() {
        return this.resolveRealClass().getName();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder(this.resolveRealClass().getCanonicalName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> getModifiers() {
        return this.resolveRealClass().getModifiers();
    }
}

