/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.DocletTag;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.Expression;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.ModelWriter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.impl.IndentBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DefaultModelWriter
implements ModelWriter {
    private IndentBuffer buffer = new IndentBuffer();

    @Override
    public ModelWriter writeSource(JavaSource javaSource) {
        this.writePackage(javaSource.getPackage());
        for (String object : javaSource.getImports()) {
            this.buffer.write("import ");
            this.buffer.write(object);
            this.buffer.write(';');
            this.buffer.newline();
        }
        if (javaSource.getImports().size() > 0) {
            this.buffer.newline();
        }
        Iterator<String> iterator = javaSource.getClasses().listIterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            this.writeClass(javaClass);
            if (!iterator.hasNext()) continue;
            this.buffer.newline();
        }
        return this;
    }

    public ModelWriter writePackage(JavaPackage javaPackage) {
        if (javaPackage != null) {
            this.commentHeader(javaPackage);
            this.buffer.write("package ");
            this.buffer.write(javaPackage.getName());
            this.buffer.write(';');
            this.buffer.newline();
            this.buffer.newline();
        }
        return this;
    }

    public ModelWriter writeClass(JavaClass javaClass) {
        Object object;
        this.commentHeader(javaClass);
        this.writeAccessibilityModifier(javaClass.getModifiers());
        this.writeNonAccessibilityModifiers(javaClass.getModifiers());
        this.buffer.write(javaClass.isEnum() ? "enum " : (javaClass.isInterface() ? "interface " : (javaClass.isAnnotation() ? "@interface " : "class ")));
        this.buffer.write(javaClass.getName());
        if (javaClass.getSuperClass() != null && !"java.lang.Object".equals(object = javaClass.getSuperClass().getFullyQualifiedName()) && !"java.lang.Enum".equals(object)) {
            this.buffer.write(" extends ");
            this.buffer.write(javaClass.getSuperClass().getGenericCanonicalName());
        }
        if (javaClass.getImplements().size() > 0) {
            this.buffer.write(javaClass.isInterface() ? " extends " : " implements ");
            object = javaClass.getImplements().listIterator();
            while (object.hasNext()) {
                this.buffer.write(((JavaType)object.next()).getGenericCanonicalName());
                if (!object.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        return this.writeClassBody(javaClass);
    }

    private ModelWriter writeClassBody(JavaClass javaClass) {
        this.buffer.write(" {");
        this.buffer.newline();
        this.buffer.indent();
        for (JavaField javaAnnotatedElement : javaClass.getFields()) {
            this.buffer.newline();
            this.writeField(javaAnnotatedElement);
        }
        for (JavaConstructor javaConstructor : javaClass.getConstructors()) {
            this.buffer.newline();
            this.writeConstructor(javaConstructor);
        }
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            this.buffer.newline();
            this.writeMethod(javaMethod);
        }
        for (JavaClass javaClass2 : javaClass.getNestedClasses()) {
            this.buffer.newline();
            this.writeClass(javaClass2);
        }
        this.buffer.deindent();
        this.buffer.newline();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeField(JavaField javaField) {
        this.commentHeader(javaField);
        this.writeAllModifiers(javaField.getModifiers());
        if (!javaField.isEnumConstant()) {
            this.buffer.write(javaField.getType().getGenericCanonicalName());
            this.buffer.write(' ');
        }
        this.buffer.write(javaField.getName());
        if (javaField.isEnumConstant()) {
            if (javaField.getEnumConstantArguments() != null && !javaField.getEnumConstantArguments().isEmpty()) {
                this.buffer.write("( ");
                ListIterator<Expression> listIterator = javaField.getEnumConstantArguments().listIterator();
                while (listIterator.hasNext()) {
                    this.buffer.write(((Expression)listIterator.next()).getParameterValue().toString());
                    if (!listIterator.hasNext()) continue;
                    this.buffer.write(", ");
                }
                this.buffer.write(" )");
            }
            if (javaField.getEnumConstantClass() != null) {
                this.writeClassBody(javaField.getEnumConstantClass());
            }
        } else if (javaField.getInitializationExpression() != null && javaField.getInitializationExpression().length() > 0) {
            this.buffer.write(" = ");
            this.buffer.write(javaField.getInitializationExpression());
        }
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeConstructor(JavaConstructor javaConstructor) {
        this.commentHeader(javaConstructor);
        this.writeAllModifiers(javaConstructor.getModifiers());
        this.buffer.write(javaConstructor.getName());
        this.buffer.write('(');
        Iterator<JavaAnnotatedElement> iterator = javaConstructor.getParameters().listIterator();
        while (iterator.hasNext()) {
            this.writeParameter(iterator.next());
            if (!iterator.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (javaConstructor.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            iterator = javaConstructor.getExceptions().iterator();
            while (iterator.hasNext()) {
                this.buffer.write(((JavaClass)iterator.next()).getGenericCanonicalName());
                if (!iterator.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        this.buffer.write(" {");
        this.buffer.newline();
        if (javaConstructor.getSourceCode() != null) {
            this.buffer.write(javaConstructor.getSourceCode());
        }
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeMethod(JavaMethod javaMethod) {
        this.commentHeader(javaMethod);
        this.writeAccessibilityModifier(javaMethod.getModifiers());
        this.writeNonAccessibilityModifiers(javaMethod.getModifiers());
        this.buffer.write(javaMethod.getReturnType().getGenericCanonicalName());
        this.buffer.write(' ');
        this.buffer.write(javaMethod.getName());
        this.buffer.write('(');
        Iterator<JavaAnnotatedElement> iterator = javaMethod.getParameters().listIterator();
        while (iterator.hasNext()) {
            this.writeParameter(iterator.next());
            if (!iterator.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (javaMethod.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            iterator = javaMethod.getExceptions().iterator();
            while (iterator.hasNext()) {
                this.buffer.write(((JavaClass)iterator.next()).getGenericCanonicalName());
                if (!iterator.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        if (javaMethod.getSourceCode() != null && javaMethod.getSourceCode().length() > 0) {
            this.buffer.write(" {");
            this.buffer.newline();
            this.buffer.write(javaMethod.getSourceCode());
            this.buffer.write('}');
            this.buffer.newline();
        } else {
            this.buffer.write(';');
            this.buffer.newline();
        }
        return this;
    }

    private void writeNonAccessibilityModifiers(Collection<String> collection) {
        for (String string : collection) {
            if (string.startsWith("p") || "interface".equals(string)) continue;
            this.buffer.write(string);
            this.buffer.write(' ');
        }
    }

    private void writeAccessibilityModifier(Collection<String> collection) {
        for (String string : collection) {
            if (!string.startsWith("p")) continue;
            this.buffer.write(string);
            this.buffer.write(' ');
        }
    }

    private void writeAllModifiers(List<String> list) {
        for (String string : list) {
            this.buffer.write(string);
            this.buffer.write(' ');
        }
    }

    public ModelWriter writeAnnotation(JavaAnnotation javaAnnotation) {
        this.buffer.write('@');
        this.buffer.write(javaAnnotation.getType().getGenericCanonicalName());
        if (!javaAnnotation.getPropertyMap().isEmpty()) {
            this.buffer.indent();
            this.buffer.write('(');
            Iterator<Map.Entry<String, AnnotationValue>> iterator = javaAnnotation.getPropertyMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AnnotationValue> entry = iterator.next();
                this.buffer.write(entry.getKey());
                this.buffer.write('=');
                this.buffer.write(entry.getValue().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.write(',');
                this.buffer.newline();
            }
            this.buffer.write(')');
            this.buffer.deindent();
        }
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeParameter(JavaParameter javaParameter) {
        this.commentHeader(javaParameter);
        this.buffer.write(javaParameter.getGenericCanonicalName());
        if (javaParameter.isVarArgs()) {
            this.buffer.write("...");
        }
        this.buffer.write(' ');
        this.buffer.write(javaParameter.getName());
        return this;
    }

    protected void commentHeader(JavaAnnotatedElement javaAnnotatedElement) {
        if (javaAnnotatedElement.getComment() != null || javaAnnotatedElement.getTags().size() > 0) {
            this.buffer.write("/**");
            this.buffer.newline();
            if (javaAnnotatedElement.getComment() != null && javaAnnotatedElement.getComment().length() > 0) {
                this.buffer.write(" * ");
                this.buffer.write(javaAnnotatedElement.getComment().replaceAll("\n", "\n * "));
                this.buffer.newline();
            }
            if (javaAnnotatedElement.getTags().size() > 0) {
                if (javaAnnotatedElement.getComment() != null && javaAnnotatedElement.getComment().length() > 0) {
                    this.buffer.write(" *");
                    this.buffer.newline();
                }
                for (DocletTag serializable : javaAnnotatedElement.getTags()) {
                    this.buffer.write(" * @");
                    this.buffer.write(serializable.getName());
                    if (serializable.getValue().length() > 0) {
                        this.buffer.write(' ');
                        this.buffer.write(serializable.getValue());
                    }
                    this.buffer.newline();
                }
            }
            this.buffer.write(" */");
            this.buffer.newline();
        }
        if (javaAnnotatedElement.getAnnotations() != null) {
            for (JavaAnnotation javaAnnotation : javaAnnotatedElement.getAnnotations()) {
                this.writeAnnotation(javaAnnotation);
            }
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

