/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OpMinus
extends Operator {
    public OpMinus(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("-", n2, n3, spelNodeImplArray);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        if (this.children.length < 2) {
            Object object = spelNodeImpl.getValueInternal(expressionState).getValue();
            if (object instanceof Number) {
                if (object instanceof BigDecimal) {
                    return new TypedValue(((BigDecimal)object).negate());
                }
                if (object instanceof Double) {
                    this.exitTypeDescriptor = "D";
                    return new TypedValue(0.0 - ((Number)object).doubleValue());
                }
                if (object instanceof Float) {
                    this.exitTypeDescriptor = "F";
                    return new TypedValue(Float.valueOf(0.0f - ((Number)object).floatValue()));
                }
                if (object instanceof BigInteger) {
                    return new TypedValue(((BigInteger)object).negate());
                }
                if (object instanceof Long) {
                    this.exitTypeDescriptor = "J";
                    return new TypedValue(0L - ((Number)object).longValue());
                }
                if (object instanceof Integer) {
                    this.exitTypeDescriptor = "I";
                    return new TypedValue(0 - ((Number)object).intValue());
                }
                if (object instanceof Short) {
                    return new TypedValue(0 - ((Number)object).shortValue());
                }
                if (object instanceof Byte) {
                    return new TypedValue(0 - ((Number)object).byteValue());
                }
                return new TypedValue(0.0 - ((Number)object).doubleValue());
            }
            return expressionState.operate(Operation.SUBTRACT, object, null);
        }
        Object object = spelNodeImpl.getValueInternal(expressionState).getValue();
        Object object2 = this.getRightOperand().getValueInternal(expressionState).getValue();
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class);
                return new TypedValue(bigDecimal.subtract(bigDecimal2));
            }
            if (number instanceof Double || number2 instanceof Double) {
                this.exitTypeDescriptor = "D";
                return new TypedValue(number.doubleValue() - number2.doubleValue());
            }
            if (number instanceof Float || number2 instanceof Float) {
                this.exitTypeDescriptor = "F";
                return new TypedValue(Float.valueOf(number.floatValue() - number2.floatValue()));
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class);
                return new TypedValue(bigInteger.subtract(bigInteger2));
            }
            if (number instanceof Long || number2 instanceof Long) {
                this.exitTypeDescriptor = "J";
                return new TypedValue(number.longValue() - number2.longValue());
            }
            if (CodeFlow.isIntegerForNumericOp(number) || CodeFlow.isIntegerForNumericOp(number2)) {
                this.exitTypeDescriptor = "I";
                return new TypedValue(number.intValue() - number2.intValue());
            }
            return new TypedValue(number.doubleValue() - number2.doubleValue());
        }
        if (object instanceof String && object2 instanceof Integer && ((String)object).length() == 1) {
            String string = (String)object;
            Integer n2 = (Integer)object2;
            return new TypedValue(Character.toString((char)(string.charAt(0) - n2)));
        }
        return expressionState.operate(Operation.SUBTRACT, object, object2);
    }

    @Override
    public String toStringAST() {
        if (this.children.length < 2) {
            return "-" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            throw new IllegalStateException("No right operand");
        }
        return this.children[1];
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.getLeftOperand().generateCode(methodVisitor, codeFlow);
        String string = this.getLeftOperand().exitTypeDescriptor;
        String string2 = this.exitTypeDescriptor;
        Assert.state(string2 != null, "No exit type descriptor");
        char c2 = string2.charAt(0);
        CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string, c2);
        if (this.children.length > 1) {
            codeFlow.enterCompilationScope();
            this.getRightOperand().generateCode(methodVisitor, codeFlow);
            String string3 = this.getRightOperand().exitTypeDescriptor;
            codeFlow.exitCompilationScope();
            CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string3, c2);
            switch (c2) {
                case 'I': {
                    methodVisitor.visitInsn(100);
                    break;
                }
                case 'J': {
                    methodVisitor.visitInsn(101);
                    break;
                }
                case 'F': {
                    methodVisitor.visitInsn(102);
                    break;
                }
                case 'D': {
                    methodVisitor.visitInsn(103);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        } else {
            switch (c2) {
                case 'I': {
                    methodVisitor.visitInsn(116);
                    break;
                }
                case 'J': {
                    methodVisitor.visitInsn(117);
                    break;
                }
                case 'F': {
                    methodVisitor.visitInsn(118);
                    break;
                }
                case 'D': {
                    methodVisitor.visitInsn(119);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

