/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.gradle.api.internal.changedetection.state.FallbackHandlingResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfAwareClasspathResourceHasher
extends FallbackHandlingResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaInfAwareClasspathResourceHasher.class);
    private final ResourceEntryFilter attributeResourceFilter;

    public MetaInfAwareClasspathResourceHasher(ResourceHasher resourceHasher, ResourceEntryFilter resourceEntryFilter) {
        super(resourceHasher);
        this.attributeResourceFilter = resourceEntryFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        super.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.attributeResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    boolean filter(RegularFileSnapshotContext regularFileSnapshotContext) {
        return MetaInfAwareClasspathResourceHasher.isManifestFile(String.join((CharSequence)"/", regularFileSnapshotContext.getRelativePathSegments().get()));
    }

    @Override
    boolean filter(ZipEntryContext zipEntryContext) {
        return !zipEntryContext.getEntry().isDirectory() && MetaInfAwareClasspathResourceHasher.isManifestFile(zipEntryContext.getEntry().getName());
    }

    @Override
    Optional<HashCode> tryHash(RegularFileSnapshotContext regularFileSnapshotContext2) {
        return Optional.of(regularFileSnapshotContext2).map(regularFileSnapshotContext -> {
            HashCode hashCode;
            FileInputStream fileInputStream = new FileInputStream(regularFileSnapshotContext.getSnapshot().getAbsolutePath());
            try {
                hashCode = this.hashManifest(fileInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    LOGGER.debug("Could not load fingerprint for " + regularFileSnapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)iOException);
                    return null;
                }
            }
            fileInputStream.close();
            return hashCode;
        });
    }

    @Override
    Optional<HashCode> tryHash(ZipEntryContext zipEntryContext) {
        return Optional.of(zipEntryContext).map(zipEntryContext2 -> {
            try {
                return zipEntryContext.getEntry().withInputStream(this::hashManifest);
            }
            catch (IOException iOException) {
                LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)iOException);
                return null;
            }
        });
    }

    private static boolean isManifestFile(String string) {
        return string.equals("META-INF/MANIFEST.MF");
    }

    private HashCode hashManifest(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Hasher hasher = Hashing.newHasher();
        Attributes attributes = manifest.getMainAttributes();
        this.hashManifestAttributes(attributes, "main", hasher);
        Map<String, Attributes> map = manifest.getEntries();
        TreeSet<String> treeSet = new TreeSet<String>(manifest.getEntries().keySet());
        for (String string : treeSet) {
            this.hashManifestAttributes(map.get(string), string, hasher);
        }
        return hasher.hash();
    }

    private void hashManifestAttributes(Attributes attributes, String string, Hasher hasher) {
        Map<String, String> map = attributes.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString().toLowerCase(Locale.ROOT), entry -> (String)entry.getValue()));
        List list = map.entrySet().stream().filter((? super T entry) -> !this.attributeResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        if (!list.isEmpty()) {
            hasher.putString(string);
            for (Map.Entry entry2 : list) {
                hasher.putString((CharSequence)entry2.getKey());
                hasher.putString((CharSequence)entry2.getValue());
            }
        }
    }
}

