/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.internal.changedetection.state.FallbackHandlingResourceHasher;
import org.gradle.api.internal.changedetection.state.PropertyResourceBundleFallbackCharset;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.UnionResourceEntryFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileAwareClasspathResourceHasher
extends FallbackHandlingResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileAwareClasspathResourceHasher.class);
    private final Map<PathMatcher, ResourceEntryFilter> propertiesFileFilters;
    private final List<String> propertiesFilePatterns;

    public PropertiesFileAwareClasspathResourceHasher(ResourceHasher resourceHasher, Map<String, ResourceEntryFilter> map) {
        super(resourceHasher);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        map.forEach((string, resourceEntryFilter) -> {
            builder2.put(PatternMatcherFactory.compile(false, string), resourceEntryFilter);
            builder.add(string);
        });
        this.propertiesFileFilters = builder2.build();
        this.propertiesFilePatterns = builder.build();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        super.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.propertiesFilePatterns.forEach(hasher::putString);
        this.propertiesFileFilters.values().forEach(resourceEntryFilter -> resourceEntryFilter.appendConfigurationToHasher(hasher));
    }

    @Override
    boolean filter(RegularFileSnapshotContext regularFileSnapshotContext) {
        return this.matchesAnyFilters(regularFileSnapshotContext.getRelativePathSegments());
    }

    @Override
    boolean filter(ZipEntryContext zipEntryContext) {
        return !zipEntryContext.getEntry().isDirectory() && this.matchesAnyFilters(zipEntryContext.getRelativePathSegments());
    }

    @Override
    public Optional<HashCode> tryHash(RegularFileSnapshotContext regularFileSnapshotContext) {
        return Optional.ofNullable(this.matchingFiltersFor(regularFileSnapshotContext.getRelativePathSegments())).map(resourceEntryFilter -> {
            HashCode hashCode;
            FileInputStream fileInputStream = new FileInputStream(regularFileSnapshotContext.getSnapshot().getAbsolutePath());
            try {
                hashCode = this.hashProperties(fileInputStream, (ResourceEntryFilter)resourceEntryFilter);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.debug("Could not load fingerprint for " + regularFileSnapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)exception);
                    return null;
                }
            }
            fileInputStream.close();
            return hashCode;
        });
    }

    @Override
    public Optional<HashCode> tryHash(ZipEntryContext zipEntryContext) {
        return Optional.ofNullable(this.matchingFiltersFor(zipEntryContext.getRelativePathSegments())).map(resourceEntryFilter -> {
            try {
                return zipEntryContext.getEntry().withInputStream(inputStream -> this.hashProperties((InputStream)inputStream, (ResourceEntryFilter)resourceEntryFilter));
            }
            catch (Exception exception) {
                LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)exception);
                return null;
            }
        });
    }

    private boolean matchesAnyFilters(Supplier<String[]> supplier) {
        return this.propertiesFileFilters.entrySet().stream().anyMatch(entry -> ((PathMatcher)entry.getKey()).matches((String[])supplier.get(), 0));
    }

    private ResourceEntryFilter matchingFiltersFor(Supplier<String[]> supplier) {
        List<ResourceEntryFilter> list = this.propertiesFileFilters.entrySet().stream().filter((? super T entry) -> ((PathMatcher)entry.getKey()).matches((String[])supplier.get(), 0)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (ResourceEntryFilter)list.get(0);
        }
        return new UnionResourceEntryFilter(list);
    }

    private HashCode hashProperties(InputStream inputStream, ResourceEntryFilter resourceEntryFilter) throws IOException {
        Hasher hasher = Hashing.newHasher();
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, new PropertyResourceBundleFallbackCharset()));
        ImmutableMap<String, String> immutableMap = Maps.fromProperties(properties);
        immutableMap.entrySet().stream().filter((? super T entry) -> !resourceEntryFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putString((CharSequence)entry.getValue());
        });
        return hasher.hash();
    }
}

