/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.ExclusiveCacheAccessCoordinator;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;

public class ExclusiveCacheAccessingWorker
implements Runnable,
Stoppable {
    private final BlockingQueue<Runnable> workQueue;
    private final String displayName;
    private final ExclusiveCacheAccessCoordinator cacheAccess;
    private final long batchWindowMillis;
    private final long maximumLockingTimeMillis;
    private boolean closed;
    private boolean workerCompleted;
    private boolean stopSeen;
    private final CountDownLatch doneSignal;
    private final ExecutorPolicy.CatchAndRecordFailures failureHandler;

    private void rethrowFailure() {
        this.failureHandler.onStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Runnable runnable;
        Object object;
        Object object2;
        try {
            while (!Thread.currentThread().isInterrupted() && !this.stopSeen) {
                try {
                    object2 = this.takeFromQueue();
                    object = object2.getClass();
                    if (object == ShutdownOperationsCommand.class) {
                        this.stopSeen = true;
                        break;
                    }
                    if (object == FlushOperationsCommand.class) {
                        runnable = (FlushOperationsCommand)object2;
                        ((FlushOperationsCommand)runnable).completed();
                        continue;
                    }
                    this.flushOperations((Runnable)object2);
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException(interruptedException);
                }
            }
            object2 = new ArrayList();
            this.workQueue.drainTo((Collection<Runnable>)object2);
        }
        catch (Throwable throwable) {
            try {
                this.failureHandler.onFailure("Failed to execute cache operations on " + this.displayName, throwable);
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                ArrayList arrayList = new ArrayList();
                this.workQueue.drainTo(arrayList);
                Iterator iterator = arrayList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.workerCompleted = true;
                        this.doneSignal.countDown();
                    }
                    Runnable runnable2 = (Runnable)iterator.next();
                    if (!(runnable2 instanceof FlushOperationsCommand)) continue;
                    FlushOperationsCommand flushOperationsCommand = (FlushOperationsCommand)runnable2;
                    flushOperationsCommand.completed();
                }
            }
        }
        object = object2.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.workerCompleted = true;
                this.doneSignal.countDown();
                return;
            }
            runnable = (Runnable)object.next();
            if (!(runnable instanceof FlushOperationsCommand)) continue;
            FlushOperationsCommand flushOperationsCommand = (FlushOperationsCommand)runnable;
            flushOperationsCommand.completed();
        }
    }

    private Runnable takeFromQueue() throws InterruptedException {
        return this.workQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOperations(final Runnable runnable) {
        final ArrayList arrayList = new ArrayList();
        try {
            this.cacheAccess.useCache(new Runnable(){

                @Override
                public void run() {
                    CountdownTimer countdownTimer = Time.startCountdownTimer(ExclusiveCacheAccessingWorker.this.maximumLockingTimeMillis, TimeUnit.MILLISECONDS);
                    if (runnable != null) {
                        ExclusiveCacheAccessingWorker.this.failureHandler.onExecute(runnable);
                    }
                    try {
                        Runnable runnable2;
                        while ((runnable2 = (Runnable)ExclusiveCacheAccessingWorker.this.workQueue.poll(ExclusiveCacheAccessingWorker.this.batchWindowMillis, TimeUnit.MILLISECONDS)) != null) {
                            ExclusiveCacheAccessingWorker.this.failureHandler.onExecute(runnable2);
                            Class<?> clazz = runnable2.getClass();
                            if (clazz == FlushOperationsCommand.class) {
                                arrayList.add((FlushOperationsCommand)runnable2);
                            }
                            if (clazz == ShutdownOperationsCommand.class) {
                                ExclusiveCacheAccessingWorker.this.stopSeen = true;
                            }
                            if (clazz != ShutdownOperationsCommand.class && clazz != FlushOperationsCommand.class && !countdownTimer.hasExpired()) continue;
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw UncheckedException.throwAsUncheckedException(interruptedException);
                    }
                }
            });
        }
        finally {
            for (FlushOperationsCommand flushOperationsCommand : arrayList) {
                flushOperationsCommand.completed();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.closed && !this.workerCompleted) {
            this.closed = true;
            try {
                this.workQueue.put(new ShutdownOperationsCommand());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                this.doneSignal.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.rethrowFailure();
    }

    private static class ShutdownOperationsCommand
    implements Runnable {
        private ShutdownOperationsCommand() {
        }

        @Override
        public void run() {
        }
    }

    private static class FlushOperationsCommand
    implements Runnable {
        private CountDownLatch latch = new CountDownLatch(1);

        private FlushOperationsCommand() {
        }

        @Override
        public void run() {
        }

        public void completed() {
            this.latch.countDown();
        }
    }
}

