/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;

public class SingleDepthFileAccessTracker
implements FileAccessTracker {
    private final Path baseDir;
    private final int endNameIndex;
    private final int startNameIndex;
    private final FileAccessTimeJournal journal;

    public SingleDepthFileAccessTracker(FileAccessTimeJournal fileAccessTimeJournal, File file, int n2) {
        this.journal = fileAccessTimeJournal;
        Preconditions.checkArgument(n2 > 0, "depth must be > 0: %s", n2);
        this.baseDir = file.toPath().toAbsolutePath();
        this.startNameIndex = this.baseDir.getNameCount();
        this.endNameIndex = this.startNameIndex + n2;
    }

    @Override
    public void markAccessed(File file) {
        Path path = file.toPath().toAbsolutePath();
        if (path.getNameCount() >= this.endNameIndex && path.startsWith(this.baseDir)) {
            path = this.baseDir.resolve(path.subpath(this.startNameIndex, this.endNameIndex));
            this.journal.setLastAccessTime(path.toFile(), System.currentTimeMillis());
        }
    }
}

