/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import java.io.IOException;
import java.io.InputStream;

public final class ISOLatinReader
extends BaseReader {
    boolean mXml11 = false;
    int mByteCount = 0;

    public ISOLatinReader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        super(readerConfig, inputStream, byArray, n2, n3, bl2);
    }

    @Override
    public void setXmlCompliancy(int n2) {
        this.mXml11 = n2 == 272;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return 0;
        }
        int n5 = this.mByteBufferEnd - this.mBytePtr;
        if (n5 <= 0) {
            this.mByteCount += this.mByteBufferEnd;
            n4 = this.readBytes();
            if (n4 <= 0) {
                if (n4 == 0) {
                    this.reportStrangeStream();
                }
                this.freeBuffers();
                return -1;
            }
            n5 = n4;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        n4 = this.mBytePtr;
        int n6 = n4 + n3;
        if (this.mXml11) {
            while (n4 < n6) {
                int n7;
                if ((n7 = (int)(this.mByteBuffer[n4++] & 0xFF)) >= 127 && n7 <= 159) {
                    if (n7 == 133) {
                        n7 = 10;
                    } else {
                        int n8 = this.mByteCount + n4;
                        this.reportInvalidXml11(n7, n8, n8);
                    }
                }
                cArray[n2++] = n7;
            }
        } else {
            while (n4 < n6) {
                cArray[n2++] = (char)(this.mByteBuffer[n4++] & 0xFF);
            }
        }
        this.mBytePtr = n6;
        return n3;
    }
}

