/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DatatypeFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Grammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceContainer;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.AttPoolClause;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.ElementRules;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.EmptyStringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.Exportable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.HedgeRules;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.NoneType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitorBoolean;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXModule;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.TagClause;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.ExpressionState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.RunAwayExpressionChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.State;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDVocabulary;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeResolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.RELAXReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.AttPoolRefState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.AttPoolState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.AttributeState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.DivInModuleState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.ElementRuleWithHedgeState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.ElementRuleWithTypeState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.HedgeRuleState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.IncludeModuleState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.InlineElementState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.InlineTagState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.InterfaceState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.MixedState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.RootModuleState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.TagState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.checker.DblAttrConstraintChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.checker.ExportedHedgeRuleChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.checker.IdAbuseChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jarv.RELAXCoreFactoryImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class RELAXCoreReader
extends RELAXReader
implements XSDatatypeResolver {
    protected static Schema relaxCoreSchema4Schema = null;
    protected RELAXModule module;
    protected final ReferenceContainer combinedAttPools = new ReferenceContainer(){

        @Override
        protected ReferenceExp createReference(String string) {
            return new ReferenceExp(string);
        }
    };
    private final Map<String, XSDatatypeExp> userDefinedTypes = new HashMap<String, XSDatatypeExp>();
    public static final String ERR_NAMESPACE_NOT_SUPPROTED = "RELAXReader.NamespaceNotSupported";
    public static final String ERR_INCONSISTENT_TARGET_NAMESPACE = "RELAXReader.InconsistentTargetNamespace";
    public static final String ERR_MISSING_TARGET_NAMESPACE = "RELAXReader.MissingTargetNamespace";
    public static final String ERR_MULTIPLE_TAG_DECLARATIONS = "RELAXReader.MultipleTagDeclarations";
    public static final String ERR_MORE_THAN_ONE_INLINE_TAG = "RELAXReader.MoreThanOneInlineTag";
    public static final String ERR_MULTIPLE_ATTPOOL_DECLARATIONS = "RELAXReader.MultipleAttPoolDeclarations";
    public static final String ERR_UNDEFINED_ELEMENTRULE = "RELAXReader.UndefinedElementRule";
    public static final String ERR_UNDEFINED_HEDGERULE = "RELAXReader.UndefinedHedgeRule";
    public static final String ERR_UNDEFINED_TAG = "RELAXReader.UndefinedTag";
    public static final String ERR_UNDEFINED_ATTPOOL = "RELAXReader.UndefinedAttPool";
    public static final String ERR_LABEL_COLLISION = "RELAXReader.LabelCollision";
    public static final String ERR_ROLE_COLLISION = "RELAXReader.RoleCollision";
    public static final String WRN_NO_EXPROTED_LABEL = "RELAXReader.NoExportedLabel";
    public static final String ERR_EXPROTED_HEDGERULE_CONSTRAINT = "RELAXReader.ExportedHedgeRuleConstraint";
    public static final String ERR_MULTIPLE_ATTRIBUTE_CONSTRAINT = "RELAXReader.MultipleAttributeConstraint";
    public static final String ERR_ID_ABUSE = "RELAXReader.IdAbuse";
    public static final String ERR_ID_ABUSE_1 = "RELAXReader.IdAbuse.1";
    public static final String WRN_ILLEGAL_RELAXCORE_VERSION = "RELAXReader.Warning.IllegalRelaxCoreVersion";

    public static RELAXModule parse(String string, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        RELAXCoreReader rELAXCoreReader = new RELAXCoreReader(grammarReaderController, sAXParserFactory, expressionPool);
        rELAXCoreReader.parse(string);
        return rELAXCoreReader.getResult();
    }

    public static RELAXModule parse(InputSource inputSource, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        RELAXCoreReader rELAXCoreReader = new RELAXCoreReader(grammarReaderController, sAXParserFactory, expressionPool);
        rELAXCoreReader.parse(inputSource);
        return rELAXCoreReader.getResult();
    }

    public static Schema getRELAXCoreSchema4Schema() {
        if (relaxCoreSchema4Schema == null) {
            try {
                relaxCoreSchema4Schema = new RELAXCoreFactoryImpl().compileSchema(RELAXCoreReader.class.getResourceAsStream("relaxCore.rlx"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("unable to load schema-for-schema for RELAX Core");
            }
        }
        return relaxCoreSchema4Schema;
    }

    public RELAXCoreReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), expressionPool, null);
    }

    public RELAXCoreReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool, String string) {
        super(grammarReaderController, sAXParserFactory, stateFactory, expressionPool, new RootModuleState(string));
    }

    public final RELAXModule getResult() {
        if (this.controller.hadError()) {
            return null;
        }
        return this.module;
    }

    @Override
    public final Grammar getResultAsGrammar() {
        return this.getResult();
    }

    @Override
    protected boolean isGrammarElement(StartTagInfo startTagInfo) {
        if (!"http://www.xml.gr.jp/xmlns/relaxCore".equals(startTagInfo.namespaceURI)) {
            return false;
        }
        return !startTagInfo.localName.equals("annotation");
    }

    public final void addUserDefinedType(XSDatatypeExp xSDatatypeExp) {
        this.userDefinedTypes.put(xSDatatypeExp.name, xSDatatypeExp);
    }

    @Override
    public XSDatatypeExp resolveXSDatatype(String string) {
        try {
            XSDatatypeExp xSDatatypeExp = this.userDefinedTypes.get(string);
            if (xSDatatypeExp != null) {
                return xSDatatypeExp;
            }
            return new XSDatatypeExp(DatatypeFactory.getTypeByName(string), this.pool);
        }
        catch (DatatypeException datatypeException) {
            XSDatatype xSDatatype = this.getBackwardCompatibleType(string);
            if (string.equals("none")) {
                xSDatatype = NoneType.theInstance;
            }
            if (string.equals("emptyString")) {
                xSDatatype = EmptyStringType.theInstance;
            }
            if (xSDatatype == null) {
                this.reportError("GrammarReader.UndefinedDataType", (Object)string);
                xSDatatype = NoneType.theInstance;
            }
            return new XSDatatypeExp(xSDatatype, this.pool);
        }
    }

    protected final StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    @Override
    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (!"http://www.xml.gr.jp/xmlns/relaxCore".equals(startTagInfo.namespaceURI)) {
            return null;
        }
        if (startTagInfo.localName.equals("mixed")) {
            return this.getStateFactory().mixed(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("element")) {
            return this.getStateFactory().element(state, startTagInfo);
        }
        return super.createExpressionChildState(state, startTagInfo);
    }

    protected boolean canHaveOccurs(ExpressionState expressionState) {
        return super.canHaveOccurs(expressionState) || expressionState instanceof InlineElementState;
    }

    @Override
    protected Expression resolveElementRef(String string, String string2) {
        if (string != null) {
            this.reportError(ERR_NAMESPACE_NOT_SUPPROTED);
            return Expression.nullSet;
        }
        ElementRules elementRules = this.module.elementRules.getOrCreate(string2);
        this.backwardReference.memorizeLink(elementRules);
        return elementRules;
    }

    @Override
    protected Expression resolveHedgeRef(String string, String string2) {
        if (string != null) {
            this.reportError(ERR_NAMESPACE_NOT_SUPPROTED);
            return Expression.nullSet;
        }
        HedgeRules hedgeRules = this.module.hedgeRules.getOrCreate(string2);
        this.backwardReference.memorizeLink(hedgeRules);
        return hedgeRules;
    }

    protected Expression resolveAttPoolRef(String string, String string2) {
        if (string != null) {
            this.reportError(ERR_NAMESPACE_NOT_SUPPROTED);
            return Expression.nullSet;
        }
        AttPoolClause attPoolClause = this.module.attPools.getOrCreate(string2);
        this.backwardReference.memorizeLink(attPoolClause);
        return attPoolClause;
    }

    protected void wrapUp() {
        Object object;
        ReferenceExp referenceExp;
        Object object2;
        this.runBackPatchJob();
        Iterator<Map.Entry<String, XSDatatypeExp>> iterator = this.userDefinedTypes.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().getValue();
            this.module.datatypes.add(((XSDatatypeExp)object2).getCreatedType());
        }
        object2 = this.combinedAttPools.getAll();
        for (int i2 = 0; i2 < ((ReferenceExp[])object2).length; ++i2) {
            referenceExp = this.module.attPools.get(((ReferenceExp)object2[i2]).name);
            if (referenceExp != null) {
                if (((AttPoolClause)referenceExp).exp == null) {
                    ((AttPoolClause)referenceExp).exp = Expression.epsilon;
                }
                ((AttPoolClause)referenceExp).exp = this.pool.createSequence(((AttPoolClause)referenceExp).exp, ((ReferenceExp)object2[i2]).exp);
                continue;
            }
            object = this.module.tags.get(((ReferenceExp)object2[i2]).name);
            if (object != null && ((TagClause)object).exp != null) {
                ((TagClause)object).exp = this.pool.createSequence(((TagClause)object).exp, ((ReferenceExp)object2[i2]).exp);
                continue;
            }
            referenceExp = this.module.attPools.getOrCreate(((ReferenceExp)object2[i2]).name);
            ((AttPoolClause)referenceExp).exp = ((ReferenceExp)object2[i2]).exp;
        }
        this.detectCollision(this.module.tags, this.module.attPools, ERR_ROLE_COLLISION);
        this.detectUndefinedOnes(this.module.elementRules, ERR_UNDEFINED_ELEMENTRULE);
        this.detectUndefinedOnes(this.module.hedgeRules, ERR_UNDEFINED_HEDGERULE);
        this.detectUndefinedOnes(this.module.tags, ERR_UNDEFINED_TAG);
        this.detectUndefinedOnes(this.module.attPools, ERR_UNDEFINED_ATTPOOL);
        this.detectCollision(this.module.elementRules, this.module.hedgeRules, ERR_LABEL_COLLISION);
        this.detectDoubleAttributeConstraints(this.module);
        IdAbuseChecker.check(this, this.module);
        object2 = this.pool.createChoice(this.choiceOfExported(this.module.elementRules), this.choiceOfExported(this.module.hedgeRules));
        if (object2 == Expression.nullSet) {
            this.reportWarning(WRN_NO_EXPROTED_LABEL);
        }
        this.module.topLevel = object2;
        RunAwayExpressionChecker.check(this, this.module.topLevel);
        Iterator<ReferenceExp> iterator2 = this.module.hedgeRules.iterator();
        while (iterator2.hasNext()) {
            referenceExp = (HedgeRules)iterator2.next();
            if (!((HedgeRules)referenceExp).exported || ((HedgeRules)referenceExp).visit((RELAXExpressionVisitorBoolean)(object = new ExportedHedgeRuleChecker(this.module)))) continue;
            String string = "";
            for (int i3 = 0; i3 < ((ExportedHedgeRuleChecker)object).errorSnapshot.length - 1; ++i3) {
                string = string + ((ExportedHedgeRuleChecker)object).errorSnapshot[i3].name + " > ";
            }
            string = string + ((ExportedHedgeRuleChecker)object).errorSnapshot[((ExportedHedgeRuleChecker)object).errorSnapshot.length - 1].name;
            this.reportError(ERR_EXPROTED_HEDGERULE_CONSTRAINT, (Object)string);
        }
    }

    private Expression choiceOfExported(ReferenceContainer referenceContainer) {
        Iterator<ReferenceExp> iterator = referenceContainer.iterator();
        Expression expression = Expression.nullSet;
        while (iterator.hasNext()) {
            Exportable exportable = (Exportable)((Object)iterator.next());
            if (!exportable.isExported()) continue;
            expression = this.pool.createChoice(expression, (Expression)((Object)exportable));
        }
        return expression;
    }

    private void detectDoubleAttributeConstraints(RELAXModule rELAXModule) {
        DblAttrConstraintChecker dblAttrConstraintChecker = new DblAttrConstraintChecker();
        Iterator<ReferenceExp> iterator = rELAXModule.tags.iterator();
        while (iterator.hasNext()) {
            dblAttrConstraintChecker.check((TagClause)iterator.next(), this);
        }
    }

    private void detectCollision(ReferenceContainer referenceContainer, ReferenceContainer referenceContainer2, String string) {
        Iterator<ReferenceExp> iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = iterator.next();
            ReferenceExp referenceExp2 = referenceContainer2._get(referenceExp.name);
            if (referenceExp2 == null || referenceExp.exp == null || referenceExp2.exp == null) continue;
            this.reportError(new Locator[]{this.getDeclaredLocationOf(referenceExp), this.getDeclaredLocationOf(referenceExp2)}, string, new Object[]{referenceExp.name});
        }
    }

    @Override
    protected String localizeMessage(String string, Object[] objectArray) {
        return super.localizeMessage(string, objectArray);
    }

    public static class StateFactory
    extends RELAXReader.StateFactory {
        protected XSDVocabulary vocabulary = new XSDVocabulary();

        protected State mixed(State state, StartTagInfo startTagInfo) {
            return new MixedState();
        }

        protected State element(State state, StartTagInfo startTagInfo) {
            return new InlineElementState();
        }

        protected State attribute(State state, StartTagInfo startTagInfo) {
            return new AttributeState();
        }

        protected State refRole(State state, StartTagInfo startTagInfo) {
            return new AttPoolRefState();
        }

        protected State divInModule(State state, StartTagInfo startTagInfo) {
            return new DivInModuleState();
        }

        protected State hedgeRule(State state, StartTagInfo startTagInfo) {
            return new HedgeRuleState();
        }

        protected State tag(State state, StartTagInfo startTagInfo) {
            return new TagState();
        }

        protected State tagInline(State state, StartTagInfo startTagInfo) {
            return new InlineTagState();
        }

        protected State attPool(State state, StartTagInfo startTagInfo) {
            return new AttPoolState();
        }

        protected State include(State state, StartTagInfo startTagInfo) {
            return new IncludeModuleState();
        }

        protected State interface_(State state, StartTagInfo startTagInfo) {
            return new InterfaceState();
        }

        protected State elementRule(State state, StartTagInfo startTagInfo) {
            if (startTagInfo.containsAttribute("type")) {
                return new ElementRuleWithTypeState();
            }
            return new ElementRuleWithHedgeState();
        }

        protected State simpleType(State state, StartTagInfo startTagInfo) {
            return this.vocabulary.createTopLevelReaderState(startTagInfo);
        }
    }
}

