/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BranchingReaderSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.BasicStreamReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ReaderCreator;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2Util;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variants;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedArrayDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedValueDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedXMLStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class TypedStreamReader
extends BasicStreamReader {
    protected static final int MASK_TYPED_ACCESS_ARRAY = 4182;
    protected static final int MASK_TYPED_ACCESS_BINARY = 4178;
    static final int MIN_BINARY_CHUNK = 2000;
    protected ValueDecoderFactory _decoderFactory;
    protected CharArrayBase64Decoder _base64Decoder = null;

    protected TypedStreamReader(InputBootstrapper inputBootstrapper, BranchingReaderSource branchingReaderSource, ReaderCreator readerCreator, ReaderConfig readerConfig, InputElementStack inputElementStack, boolean bl2) throws XMLStreamException {
        super(inputBootstrapper, branchingReaderSource, readerCreator, readerConfig, inputElementStack, bl2);
    }

    public static TypedStreamReader createStreamReader(BranchingReaderSource branchingReaderSource, ReaderCreator readerCreator, ReaderConfig readerConfig, InputBootstrapper inputBootstrapper, boolean bl2) throws XMLStreamException {
        TypedStreamReader typedStreamReader = new TypedStreamReader(inputBootstrapper, branchingReaderSource, readerCreator, readerConfig, TypedStreamReader.createElementStack(readerConfig), bl2);
        return typedStreamReader;
    }

    @Override
    public boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder booleanDecoder = this._decoderFactory().getBooleanDecoder();
        this.getElementAs(booleanDecoder);
        return booleanDecoder.getValue();
    }

    @Override
    public int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder intDecoder = this._decoderFactory().getIntDecoder();
        this.getElementAs(intDecoder);
        return intDecoder.getValue();
    }

    @Override
    public long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder longDecoder = this._decoderFactory().getLongDecoder();
        this.getElementAs(longDecoder);
        return longDecoder.getValue();
    }

    @Override
    public float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder floatDecoder = this._decoderFactory().getFloatDecoder();
        this.getElementAs(floatDecoder);
        return floatDecoder.getValue();
    }

    @Override
    public double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder doubleDecoder = this._decoderFactory().getDoubleDecoder();
        this.getElementAs(doubleDecoder);
        return doubleDecoder.getValue();
    }

    @Override
    public BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder integerDecoder = this._decoderFactory().getIntegerDecoder();
        this.getElementAs(integerDecoder);
        return integerDecoder.getValue();
    }

    @Override
    public BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder decimalDecoder = this._decoderFactory().getDecimalDecoder();
        this.getElementAs(decimalDecoder);
        return decimalDecoder.getValue();
    }

    @Override
    public QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder qNameDecoder = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs(qNameDecoder);
        return this._verifyQName(qNameDecoder.getValue());
    }

    @Override
    public final byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    @Override
    public byte[] getElementAsBinary(Base64Variant base64Variant) throws XMLStreamException {
        Stax2Util.ByteAggregator byteAggregator = this._base64Decoder().getByteAggregator();
        byte[] byArray = byteAggregator.startAggregation();
        while (true) {
            int n2;
            int n3 = 0;
            int n4 = byArray.length;
            do {
                if ((n2 = this.readElementAsBinary(byArray, n3, n4, base64Variant)) < 1) {
                    return byteAggregator.aggregateAll(byArray, n3);
                }
                n3 += n2;
            } while ((n4 -= n2) > 0);
            byArray = byteAggregator.addFullBlock(byArray);
        }
    }

    @Override
    public void getElementAs(TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        int n2;
        int n3;
        if (this.mCurrToken != 1) {
            this.throwParseError(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mStEmptyElem) {
            this.mStEmptyElem = false;
            this.mCurrToken = 2;
            this._handleEmptyValue(typedValueDecoder);
            return;
        }
        do {
            if ((n3 = this.next()) != 2) continue;
            this._handleEmptyValue(typedValueDecoder);
            return;
        } while (n3 == 5 || n3 == 3);
        if ((1 << n3 & 0x1250) == 0) {
            this.throwParseError("Expected a text token, got " + this.tokenTypeDesc(n3) + ".");
        }
        if (this.mTokenState < 3) {
            this.readCoalescedText(this.mCurrToken, false);
        }
        if (this.mInputPtr + 1 < this.mInputEnd && this.mInputBuffer[this.mInputPtr] == '<' && this.mInputBuffer[this.mInputPtr + 1] == '/') {
            this.mInputPtr += 2;
            this.mCurrToken = 2;
            try {
                this.mTextBuffer.decode(typedValueDecoder);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructTypeException(illegalArgumentException, this.mTextBuffer.contentsAsString());
            }
            this.readEndElem();
            return;
        }
        n3 = 1 + (this.mTextBuffer.size() >> 1);
        StringBuilder stringBuilder = this.mTextBuffer.contentsAsStringBuilder(n3);
        while ((n2 = this.next()) != 2) {
            if ((1 << n2 & 0x1250) != 0) {
                if (this.mTokenState < 3) {
                    this.readCoalescedText(n2, false);
                }
                this.mTextBuffer.contentsToStringBuilder(stringBuilder);
                continue;
            }
            if (n2 == 5 || n2 == 3) continue;
            this.throwParseError("Expected a text token, got " + this.tokenTypeDesc(n2) + ".");
        }
        String string = stringBuilder.toString();
        String string2 = Stax2Util.trimSpaces(string);
        if (string2 == null) {
            this._handleEmptyValue(typedValueDecoder);
        } else {
            try {
                typedValueDecoder.decode(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructTypeException(illegalArgumentException, string);
            }
        }
    }

    @Override
    public int readElementAsIntArray(int[] nArray, int n2, int n3) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getIntArrayDecoder(nArray, n2, n3));
    }

    @Override
    public int readElementAsLongArray(long[] lArray, int n2, int n3) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getLongArrayDecoder(lArray, n2, n3));
    }

    @Override
    public int readElementAsFloatArray(float[] fArray, int n2, int n3) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getFloatArrayDecoder(fArray, n2, n3));
    }

    @Override
    public int readElementAsDoubleArray(double[] dArray, int n2, int n3) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getDoubleArrayDecoder(dArray, n2, n3));
    }

    @Override
    public final int readElementAsArray(TypedArrayDecoder typedArrayDecoder) throws XMLStreamException {
        int n2 = this.mCurrToken;
        if ((1 << n2 & 0x1056) == 0) {
            this.throwNotTextualOrElem(n2);
        }
        if (n2 == 1) {
            if (this.mStEmptyElem) {
                this.mStEmptyElem = false;
                this.mCurrToken = 2;
                return -1;
            }
            do {
                if ((n2 = this.next()) != 2) continue;
                return -1;
            } while (n2 == 5 || n2 == 3);
            if (n2 != 4 && n2 != 12) {
                throw this._constructUnexpectedInTyped(n2);
            }
        }
        int n3 = 0;
        while (n2 != 2) {
            if (n2 == 4 || n2 == 12 || n2 == 6) {
                if (this.mTokenState < 3) {
                    this.readCoalescedText(n2, false);
                }
            } else {
                if (n2 == 5 || n2 == 3) {
                    n2 = this.next();
                    continue;
                }
                throw this._constructUnexpectedInTyped(n2);
            }
            n3 += this.mTextBuffer.decodeElements(typedArrayDecoder, this);
            if (!typedArrayDecoder.hasRoom()) break;
            n2 = this.next();
        }
        return n3 > 0 ? n3 : -1;
    }

    @Override
    public final int readElementAsBinary(byte[] byArray, int n2, int n3) throws XMLStreamException {
        return this.readElementAsBinary(byArray, n2, n3, Base64Variants.getDefaultVariant());
    }

    @Override
    public int readElementAsBinary(byte[] byArray, int n2, int n3, Base64Variant base64Variant) throws XMLStreamException {
        if (byArray == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal offset (" + n2 + "), must be [0, " + byArray.length + "[");
        }
        if (n3 < 1 || n2 + n3 > byArray.length) {
            if (n3 == 0) {
                return 0;
            }
            throw new IllegalArgumentException("Illegal maxLength (" + n3 + "), has to be positive number, and offset+maxLength can not exceed" + byArray.length);
        }
        CharArrayBase64Decoder charArrayBase64Decoder = this._base64Decoder();
        int n4 = this.mCurrToken;
        if ((1 << n4 & 0x1052) == 0) {
            if (n4 == 2) {
                if (!charArrayBase64Decoder.hasData()) {
                    return -1;
                }
            } else {
                this.throwNotTextualOrElem(n4);
            }
        } else if (n4 == 1) {
            if (this.mStEmptyElem) {
                this.mStEmptyElem = false;
                this.mCurrToken = 2;
                return -1;
            }
            do {
                if ((n4 = this.next()) != 2) continue;
                return -1;
            } while (n4 == 5 || n4 == 3);
            if (this.mTokenState < this.mStTextThreshold) {
                this.finishToken(false);
            }
            this._initBinaryChunks(base64Variant, charArrayBase64Decoder, n4, true);
        }
        int n5 = 0;
        while (true) {
            int n6;
            try {
                n6 = charArrayBase64Decoder.decode(byArray, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructTypeException(illegalArgumentException.getMessage(), "");
            }
            n2 += n6;
            n5 += n6;
            if ((n3 -= n6) < 1 || this.mCurrToken == 2) break;
            while ((n4 = this.next()) == 5 || n4 == 3 || n4 == 6) {
            }
            if (n4 == 2) {
                int n7 = charArrayBase64Decoder.endOfContent();
                if (n7 < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (n7 <= 0) break;
                continue;
            }
            if (this.mTokenState < this.mStTextThreshold) {
                this.finishToken(false);
            }
            this._initBinaryChunks(base64Variant, charArrayBase64Decoder, n4, false);
        }
        return n5 > 0 ? n5 : -1;
    }

    private final void _initBinaryChunks(Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, int n2, boolean bl2) throws XMLStreamException {
        if (n2 == 4) {
            if (this.mTokenState < this.mStTextThreshold) {
                this.mTokenState = this.readTextSecondary(2000, false) ? 3 : 2;
            }
        } else if (n2 == 12) {
            if (this.mTokenState < this.mStTextThreshold) {
                this.mTokenState = this.readCDataSecondary(2000) ? 3 : 2;
            }
        } else {
            throw this._constructUnexpectedInTyped(n2);
        }
        this.mTextBuffer.initBinaryChunks(base64Variant, charArrayBase64Decoder, bl2);
    }

    @Override
    public int getAttributeIndex(String string, String string2) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this.mElementStack.findAttributeIndex(string, string2);
    }

    @Override
    public boolean getAttributeAsBoolean(int n2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder booleanDecoder = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(n2, booleanDecoder);
        return booleanDecoder.getValue();
    }

    @Override
    public int getAttributeAsInt(int n2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder intDecoder = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(n2, intDecoder);
        return intDecoder.getValue();
    }

    @Override
    public long getAttributeAsLong(int n2) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder longDecoder = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(n2, longDecoder);
        return longDecoder.getValue();
    }

    @Override
    public float getAttributeAsFloat(int n2) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder floatDecoder = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(n2, floatDecoder);
        return floatDecoder.getValue();
    }

    @Override
    public double getAttributeAsDouble(int n2) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder doubleDecoder = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(n2, doubleDecoder);
        return doubleDecoder.getValue();
    }

    @Override
    public BigInteger getAttributeAsInteger(int n2) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder integerDecoder = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(n2, integerDecoder);
        return integerDecoder.getValue();
    }

    @Override
    public BigDecimal getAttributeAsDecimal(int n2) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder decimalDecoder = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(n2, decimalDecoder);
        return decimalDecoder.getValue();
    }

    @Override
    public QName getAttributeAsQName(int n2) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder qNameDecoder = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(n2, qNameDecoder);
        return this._verifyQName(qNameDecoder.getValue());
    }

    @Override
    public void getAttributeAs(int n2, TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        try {
            this.mAttrCollector.decodeValue(n2, typedValueDecoder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructTypeException(illegalArgumentException, this.mAttrCollector.getValue(n2));
        }
    }

    @Override
    public int[] getAttributeAsIntArray(int n2) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder intArrayDecoder = this._decoderFactory().getIntArrayDecoder();
        this.getAttributeAsArray(n2, intArrayDecoder);
        return intArrayDecoder.getValues();
    }

    @Override
    public long[] getAttributeAsLongArray(int n2) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder longArrayDecoder = this._decoderFactory().getLongArrayDecoder();
        this.getAttributeAsArray(n2, longArrayDecoder);
        return longArrayDecoder.getValues();
    }

    @Override
    public float[] getAttributeAsFloatArray(int n2) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder floatArrayDecoder = this._decoderFactory().getFloatArrayDecoder();
        this.getAttributeAsArray(n2, floatArrayDecoder);
        return floatArrayDecoder.getValues();
    }

    @Override
    public double[] getAttributeAsDoubleArray(int n2) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder doubleArrayDecoder = this._decoderFactory().getDoubleArrayDecoder();
        this.getAttributeAsArray(n2, doubleArrayDecoder);
        return doubleArrayDecoder.getValues();
    }

    @Override
    public int getAttributeAsArray(int n2, TypedArrayDecoder typedArrayDecoder) throws XMLStreamException {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this.mAttrCollector.decodeValues(n2, typedArrayDecoder, this);
    }

    @Override
    public byte[] getAttributeAsBinary(int n2) throws XMLStreamException {
        return this.getAttributeAsBinary(n2, Base64Variants.getDefaultVariant());
    }

    @Override
    public byte[] getAttributeAsBinary(int n2, Base64Variant base64Variant) throws XMLStreamException {
        return this.mAttrCollector.decodeBinary(n2, base64Variant, this._base64Decoder(), this);
    }

    protected QName _verifyQName(QName qName) throws TypedXMLStreamException {
        String string = qName.getLocalPart();
        int n2 = WstxInputData.findIllegalNameChar(string, this.mCfgNsEnabled, this.mXml11);
        if (n2 >= 0) {
            String string2 = qName.getPrefix();
            String string3 = string2 != null && string2.length() > 0 ? string2 + ":" + string : string;
            throw this._constructTypeException("Invalid local name \"" + string + "\" (character at #" + n2 + " is invalid)", string3);
        }
        return qName;
    }

    protected ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected CharArrayBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new CharArrayBase64Decoder();
        }
        return this._base64Decoder;
    }

    private void _handleEmptyValue(TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        try {
            typedValueDecoder.handleEmptyValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructTypeException(illegalArgumentException, "");
        }
    }

    protected TypedXMLStreamException _constructTypeException(IllegalArgumentException illegalArgumentException, String string) {
        return new TypedXMLStreamException(string, illegalArgumentException.getMessage(), this.getStartLocation(), illegalArgumentException);
    }
}

