/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.ContentReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.deser.ElementWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.Stax2JacksonReaderAdapter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamLocation2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamReader2;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlTokenStream {
    protected final XMLStreamReader2 _xmlReader;
    protected final ContentReference _sourceReference;
    protected int _formatFeatures;
    protected boolean _cfgProcessXsiNil;
    protected boolean _cfgProcessXsiType;
    protected XmlNameProcessor _nameProcessor;
    protected int _currentState;
    protected int _attributeCount;
    protected boolean _xsiNilFound;
    protected boolean _startElementAfterText;
    protected int _nextAttributeIndex;
    protected String _localName;
    protected String _namespaceURI;
    protected String _textValue;
    protected boolean _repeatCurrentToken;
    protected XmlNameProcessor.XmlName _nameToDecode = new XmlNameProcessor.XmlName();
    protected int _repeatElement;
    protected ElementWrapper _currentWrapper;
    protected String _nextLocalName;
    protected String _nextNamespaceURI;

    public XmlTokenStream(XMLStreamReader xMLStreamReader, ContentReference contentReference, int n2, XmlNameProcessor xmlNameProcessor) {
        this._sourceReference = contentReference;
        this._formatFeatures = n2;
        this._cfgProcessXsiNil = FromXmlParser.Feature.PROCESS_XSI_NIL.enabledIn(this._formatFeatures);
        this._cfgProcessXsiType = FromXmlParser.Feature.AUTO_DETECT_XSI_TYPE.enabledIn(this._formatFeatures);
        this._xmlReader = Stax2JacksonReaderAdapter.wrapIfNecessary(xMLStreamReader);
        this._nameProcessor = xmlNameProcessor;
    }

    public int initialize() throws XMLStreamException {
        if (this._xmlReader.getEventType() != 1) {
            throw new IllegalArgumentException("Invalid XMLStreamReader passed: should be pointing to START_ELEMENT (1), instead got " + this._xmlReader.getEventType());
        }
        this._checkXsiAttributes();
        this._decodeElementName(this._xmlReader.getNamespaceURI(), this._xmlReader.getLocalName());
        if (this._xmlReader.isEmptyElement() && FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL.enabledIn(this._formatFeatures) && !this._xsiNilFound && this._attributeCount < 1) {
            this._textValue = null;
            this._startElementAfterText = false;
            this._currentState = 7;
            return 7;
        }
        this._currentState = 1;
        return 1;
    }

    protected void setFormatFeatures(int n2) {
        this._formatFeatures = n2;
        this._cfgProcessXsiNil = FromXmlParser.Feature.PROCESS_XSI_NIL.enabledIn(n2);
        this._cfgProcessXsiType = FromXmlParser.Feature.AUTO_DETECT_XSI_TYPE.enabledIn(n2);
    }

    public int next() throws XMLStreamException {
        if (this._repeatCurrentToken) {
            this._repeatCurrentToken = false;
            return this._currentState;
        }
        if (this._repeatElement != 0) {
            this._currentState = this._handleRepeatElement();
            return this._currentState;
        }
        return this._next();
    }

    public void skipEndElement() throws IOException, XMLStreamException {
        int n2 = this.next();
        if (n2 != 2) {
            throw new IOException(String.format("Internal error: Expected END_ELEMENT, got event of type %s", this._stateDesc(n2)));
        }
    }

    public String getText() {
        return this._textValue;
    }

    public String getLocalName() {
        return this._localName;
    }

    public boolean hasXsiNil() {
        return this._xsiNilFound;
    }

    public void closeCompletely() throws XMLStreamException {
        this._xmlReader.closeCompletely();
    }

    public void close() throws XMLStreamException {
        this._xmlReader.close();
    }

    public JsonLocation getCurrentLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getCurrentLocation());
    }

    public JsonLocation getTokenLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getStartLocation());
    }

    protected void repeatStartElement() {
        if (this._currentState != 1) {
            if (this._currentState == 2) {
                return;
            }
            throw new IllegalStateException("Current state not XML_START_ELEMENT but " + this._currentStateDesc());
        }
        this._currentWrapper = this._currentWrapper == null ? ElementWrapper.matchingWrapper(null, this._localName, this._namespaceURI) : ElementWrapper.matchingWrapper(this._currentWrapper.getParent(), this._localName, this._namespaceURI);
        this._repeatElement = 1;
    }

    protected void pushbackCurrentToken() {
        this._repeatCurrentToken = true;
    }

    protected void skipAttributes() {
        switch (this._currentState) {
            case 3: {
                this._attributeCount = 0;
                this._currentState = 1;
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalStateException("Current state not XML_START_ELEMENT or XML_ATTRIBUTE_NAME but " + this._currentStateDesc());
            }
        }
    }

    private final int _next() throws XMLStreamException {
        switch (this._currentState) {
            case 4: {
                ++this._nextAttributeIndex;
            }
            case 1: {
                boolean bl2;
                if (this._xsiNilFound) {
                    this._xsiNilFound = false;
                    this._xmlReader.skipElement();
                    return this._handleEndElement();
                }
                if (this._nextAttributeIndex < this._attributeCount) {
                    this._decodeAttributeName(this._xmlReader.getAttributeNamespace(this._nextAttributeIndex), this._xmlReader.getAttributeLocalName(this._nextAttributeIndex));
                    this._textValue = this._xmlReader.getAttributeValue(this._nextAttributeIndex);
                    this._currentState = 3;
                    return 3;
                }
                String string = this._collectUntilTag();
                boolean bl3 = bl2 = this._xmlReader.getEventType() == 1;
                if (bl2) {
                    if (XmlTokenStream._allWs(string)) {
                        this._startElementAfterText = false;
                        return this._initStartElement();
                    }
                    this._startElementAfterText = true;
                    this._textValue = string;
                    this._currentState = 5;
                    return 5;
                }
                if (string != null) {
                    this._startElementAfterText = false;
                    this._textValue = string;
                    this._currentState = 5;
                    return 5;
                }
                this._startElementAfterText = false;
                return this._handleEndElement();
            }
            case 3: {
                this._currentState = 4;
                return 4;
            }
            case 5: {
                if (this._startElementAfterText) {
                    this._startElementAfterText = false;
                    return this._initStartElement();
                }
                return this._handleEndElement();
            }
            case 7: {
                this.close();
                this._currentState = 8;
                return 8;
            }
            case 8: {
                return 8;
            }
        }
        switch (this._skipAndCollectTextUntilTag()) {
            case 8: {
                this.close();
                this._currentState = 8;
                return 8;
            }
            case 2: {
                if (!XmlTokenStream._allWs(this._textValue)) {
                    this._currentState = 5;
                    return 5;
                }
                return this._handleEndElement();
            }
        }
        if (!XmlTokenStream._allWs(this._textValue)) {
            this._startElementAfterText = true;
            this._currentState = 5;
            return 5;
        }
        return this._initStartElement();
    }

    private final String _collectUntilTag() throws XMLStreamException {
        if (this._xmlReader.isEmptyElement()) {
            this._xmlReader.next();
            if (FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL.enabledIn(this._formatFeatures)) {
                return null;
            }
            return "";
        }
        CharSequence charSequence = null;
        block5: while (this._xmlReader.hasNext()) {
            switch (this._xmlReader.next()) {
                case 1: {
                    break block5;
                }
                case 2: 
                case 8: {
                    break block5;
                }
                case 4: 
                case 12: {
                    String string = this._getText(this._xmlReader);
                    if (charSequence == null) {
                        charSequence = string;
                        continue block5;
                    }
                    if (charSequence instanceof String) {
                        charSequence = new StringBuilder(charSequence);
                    }
                    ((StringBuilder)charSequence).append(string);
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        return charSequence == null ? "" : charSequence.toString();
    }

    private final int _skipAndCollectTextUntilTag() throws XMLStreamException {
        CharSequence charSequence = null;
        while (this._xmlReader.hasNext()) {
            int n2 = this._xmlReader.next();
            switch (n2) {
                case 1: 
                case 2: 
                case 8: {
                    this._textValue = charSequence == null ? "" : charSequence.toString();
                    return n2;
                }
                case 4: 
                case 12: {
                    String string = this._getText(this._xmlReader);
                    if (charSequence == null) {
                        charSequence = string;
                        break;
                    }
                    if (charSequence instanceof String) {
                        charSequence = new StringBuilder(charSequence);
                    }
                    ((StringBuilder)charSequence).append(string);
                    break;
                }
            }
        }
        throw new IllegalStateException("Expected to find a tag, instead reached end of input");
    }

    private final String _getText(XMLStreamReader2 xMLStreamReader2) throws XMLStreamException {
        try {
            return xMLStreamReader2.getText();
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof XMLStreamException) {
                throw (XMLStreamException)throwable;
            }
            throw runtimeException;
        }
    }

    private final int _initStartElement() throws XMLStreamException {
        String string = this._xmlReader.getNamespaceURI();
        String string2 = this._xmlReader.getLocalName();
        this._checkXsiAttributes();
        if (this._currentWrapper != null) {
            if (this._currentWrapper.matchesWrapper(string2, string)) {
                this._currentWrapper = this._currentWrapper.intermediateWrapper();
            } else {
                this._localName = this._currentWrapper.getWrapperLocalName();
                this._namespaceURI = this._currentWrapper.getWrapperNamespace();
                this._currentWrapper = this._currentWrapper.getParent();
                this._nextLocalName = string2;
                this._nextNamespaceURI = string;
                this._repeatElement = 3;
                this._currentState = 2;
                return 2;
            }
        }
        this._decodeElementName(string, string2);
        this._currentState = 1;
        return 1;
    }

    private final void _checkXsiAttributes() {
        int n2;
        this._attributeCount = n2 = this._xmlReader.getAttributeCount();
        if (n2 >= 1 && this._cfgProcessXsiNil && "nil".equals(this._xmlReader.getAttributeLocalName(0)) && "http://www.w3.org/2001/XMLSchema-instance".equals(this._xmlReader.getAttributeNamespace(0))) {
            this._nextAttributeIndex = 1;
            this._xsiNilFound = "true".equals(this._xmlReader.getAttributeValue(0));
            return;
        }
        this._nextAttributeIndex = 0;
        this._xsiNilFound = false;
    }

    protected void _decodeElementName(String string, String string2) {
        if (this._cfgProcessXsiType && string2.equals("type") && "http://www.w3.org/2001/XMLSchema-instance".equals(string)) {
            this._localName = "xsi:type";
            this._namespaceURI = "";
            return;
        }
        this._nameToDecode.namespace = string;
        this._nameToDecode.localPart = string2;
        this._nameProcessor.decodeName(this._nameToDecode);
        this._namespaceURI = this._nameToDecode.namespace;
        this._localName = this._nameToDecode.localPart;
    }

    protected void _decodeAttributeName(String string, String string2) {
        if (this._cfgProcessXsiType && string2.equals("type") && "http://www.w3.org/2001/XMLSchema-instance".equals(string)) {
            this._localName = "xsi:type";
            this._namespaceURI = "";
            return;
        }
        this._nameToDecode.namespace = string;
        this._nameToDecode.localPart = string2;
        this._nameProcessor.decodeName(this._nameToDecode);
        this._namespaceURI = this._nameToDecode.namespace;
        this._localName = this._nameToDecode.localPart;
    }

    protected int _handleRepeatElement() throws XMLStreamException {
        int n2 = this._repeatElement;
        this._repeatElement = 0;
        if (n2 == 1) {
            this._currentWrapper = this._currentWrapper.intermediateWrapper();
            return 1;
        }
        if (n2 == 2) {
            this._decodeElementName(this._xmlReader.getNamespaceURI(), this._xmlReader.getLocalName());
            if (this._currentWrapper != null) {
                this._currentWrapper = this._currentWrapper.getParent();
            }
            return 2;
        }
        if (n2 == 3) {
            if (this._currentWrapper != null) {
                this._currentWrapper = this._currentWrapper.intermediateWrapper();
            }
            this._decodeElementName(this._nextNamespaceURI, this._nextLocalName);
            this._nextLocalName = null;
            this._nextNamespaceURI = null;
            return 1;
        }
        throw new IllegalStateException("Unrecognized type to repeat: " + n2);
    }

    private final int _handleEndElement() {
        if (this._currentWrapper != null) {
            ElementWrapper elementWrapper = this._currentWrapper;
            if (elementWrapper.isMatching()) {
                this._repeatElement = 2;
                this._localName = elementWrapper.getWrapperLocalName();
                this._namespaceURI = elementWrapper.getWrapperNamespace();
                this._currentWrapper = this._currentWrapper.getParent();
            } else {
                this._currentWrapper = this._currentWrapper.getParent();
                this._localName = "";
                this._namespaceURI = "";
            }
        } else {
            this._localName = "";
            this._namespaceURI = "";
        }
        this._currentState = 2;
        return 2;
    }

    private JsonLocation _extractLocation(XMLStreamLocation2 xMLStreamLocation2) {
        if (xMLStreamLocation2 == null) {
            return new JsonLocation(this._sourceReference, -1L, -1, -1);
        }
        return new JsonLocation(this._sourceReference, xMLStreamLocation2.getCharacterOffset(), xMLStreamLocation2.getLineNumber(), xMLStreamLocation2.getColumnNumber());
    }

    protected static boolean _allWs(String string) {
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (string.charAt(i2) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    protected String _currentStateDesc() {
        return this._stateDesc(this._currentState);
    }

    protected String _stateDesc(int n2) {
        switch (n2) {
            case 1: {
                return "XML_START_ELEMENT";
            }
            case 2: {
                return "XML_END_ELEMENT";
            }
            case 3: {
                return "XML_ATTRIBUTE_NAME";
            }
            case 4: {
                return "XML_ATTRIBUTE_VALUE";
            }
            case 5: {
                return "XML_TEXT";
            }
            case 7: {
                return "XML_ROOT_TEXT";
            }
            case 8: {
                return "XML_END";
            }
        }
        return "N/A (" + this._currentState + ")";
    }
}

