/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamWriteConstraints;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.base.GeneratorBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.JsonWriteContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamWriter2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2WriterAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ToXmlGenerator
extends GeneratorBase {
    protected final XMLStreamWriter2 _xmlWriter;
    protected final XMLStreamWriter _originalXmlWriter;
    protected final boolean _stax2Emulation;
    protected final StreamWriteConstraints _streamWriteConstraints;
    protected int _formatFeatures;
    protected XmlPrettyPrinter _xmlPrettyPrinter;
    protected XmlNameProcessor _nameProcessor;
    protected boolean _initialized;
    protected QName _nextName = null;
    protected boolean _nextIsAttribute = false;
    protected boolean _nextIsUnwrapped = false;
    protected boolean _nextIsCData = false;
    protected LinkedList<QName> _elementNameStack = new LinkedList();
    protected XmlNameProcessor.XmlName _nameToEncode = new XmlNameProcessor.XmlName();

    public ToXmlGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, XMLStreamWriter xMLStreamWriter, XmlNameProcessor xmlNameProcessor) {
        super(n2, objectCodec, iOContext);
        this._formatFeatures = n3;
        this._streamWriteConstraints = iOContext.streamWriteConstraints();
        this._originalXmlWriter = xMLStreamWriter;
        this._xmlWriter = Stax2WriterAdapter.wrapIfNecessary(xMLStreamWriter);
        this._stax2Emulation = this._xmlWriter != xMLStreamWriter;
        this._nameProcessor = xmlNameProcessor;
        this._xmlPrettyPrinter = this._cfgPrettyPrinter instanceof XmlPrettyPrinter ? (XmlPrettyPrinter)this._cfgPrettyPrinter : null;
    }

    public void initGenerator() throws IOException {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        try {
            boolean bl2;
            if (Feature.WRITE_XML_1_1.enabledIn(this._formatFeatures)) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.1");
                bl2 = true;
            } else if (Feature.WRITE_XML_DECLARATION.enabledIn(this._formatFeatures)) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.0");
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl2 && this._xmlPrettyPrinter != null && !this._stax2Emulation) {
                this._xmlPrettyPrinter.writePrologLinefeed(this._xmlWriter);
            }
            if (Feature.AUTO_DETECT_XSI_TYPE.enabledIn(this._formatFeatures)) {
                this._xmlWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        this._xmlPrettyPrinter = prettyPrinter instanceof XmlPrettyPrinter ? (XmlPrettyPrinter)prettyPrinter : null;
        return this;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        int n4 = this._formatFeatures;
        int n5 = this._formatFeatures & ~n3 | n2 & n3;
        if (n4 != n5) {
            this._formatFeatures = n5;
        }
        return this;
    }

    @Override
    public StreamWriteConstraints streamWriteConstraints() {
        return this._streamWriteConstraints;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    public boolean inRoot() {
        return this._writeContext.inRoot();
    }

    public XMLStreamWriter getStaxWriter() {
        return this._xmlWriter;
    }

    public void setNextIsAttribute(boolean bl2) {
        this._nextIsAttribute = bl2;
    }

    public void setNextIsUnwrapped(boolean bl2) {
        this._nextIsUnwrapped = bl2;
    }

    public void setNextIsCData(boolean bl2) {
        this._nextIsCData = bl2;
    }

    public final void setNextName(QName qName) {
        this._nextName = qName;
    }

    public final boolean setNextNameIfMissing(QName qName) {
        if (this._nextName == null) {
            this._nextName = qName;
            return true;
        }
        return false;
    }

    public void startWrappedValue(QName qName, QName qName2) throws IOException {
        if (qName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeStartElement(this._xmlWriter, qName.getNamespaceURI(), qName.getLocalPart());
                } else {
                    this._xmlWriter.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, this);
            }
        }
        this.setNextName(qName2);
    }

    public void finishWrappedValue(QName qName, QName qName2) throws IOException {
        if (qName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeEndElement(this._xmlWriter, this._writeContext.getEntryCount());
                } else {
                    this._xmlWriter.writeEndElement();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, this);
            }
        }
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        this.writeFieldName(serializableString.getValue());
    }

    @Override
    public final void writeFieldName(String string) throws IOException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (Feature.AUTO_DETECT_XSI_TYPE.enabledIn(this._formatFeatures) && "xsi:type".equals(string)) {
            this.setNextName(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"));
            this.setNextIsAttribute(true);
        } else {
            String string2;
            this._nameToEncode.namespace = string2 = this._nextName == null ? "" : this._nextName.getNamespaceURI();
            this._nameToEncode.localPart = string;
            this._nameProcessor.encodeName(this._nameToEncode);
            this.setNextName(new QName(this._nameToEncode.namespace, this._nameToEncode.localPart));
        }
    }

    @Override
    public final void writeStringField(String string, String string2) throws IOException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this.streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        }
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        }
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this.streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            this._handleStartObject();
        }
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._cfgPrettyPrinter != null) {
            int n2 = this._nextIsAttribute ? 0 : this._writeContext.getEntryCount();
            this._cfgPrettyPrinter.writeEndObject(this, n2);
        } else {
            this._handleEndObject();
        }
    }

    public final void _handleStartObject() throws IOException {
        if (this._nextName == null) {
            this.handleMissingName();
        }
        this._elementNameStack.addLast(this._nextName);
        try {
            this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    public final void _handleEndObject() throws IOException {
        if (this._elementNameStack.isEmpty()) {
            throw new JsonGenerationException("Can not write END_ELEMENT without open START_ELEMENT", (JsonGenerator)this);
        }
        this._nextName = this._elementNameStack.removeLast();
        try {
            this._nextIsAttribute = false;
            this._xmlWriter.writeEndElement();
            if (this._elementNameStack.isEmpty() && this._xmlPrettyPrinter != null && !this._stax2Emulation) {
                this._xmlPrettyPrinter.writePrologLinefeed(this._xmlWriter);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), string);
            } else if (this.checkNextIsUnwrapped()) {
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(string);
                } else {
                    this._xmlWriter.writeCharacters(string);
                }
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), string, this._nextIsCData);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(string);
                } else {
                    this._xmlWriter.writeCharacters(string);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), new String(cArray, n2, n3));
            } else if (this.checkNextIsUnwrapped()) {
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(cArray, n2, n3);
                } else {
                    this._xmlWriter.writeCharacters(cArray, n2, n3);
                }
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), cArray, n2, n3, this._nextIsCData);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(cArray, n2, n3);
                } else {
                    this._xmlWriter.writeCharacters(cArray, n2, n3);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
        this.writeString(serializableString.getValue());
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRawValue");
        }
        try {
            this._verifyValueWrite("write raw value");
            if (this._nextName == null) {
                this.handleMissingName();
            }
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), string);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeRaw(string);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeRaw(string);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeRawValue(SerializableString serializableString) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) throws IOException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(string);
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(cArray, n2, n3);
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        this.writeRaw(String.valueOf(c2));
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant base64Variant2 = StaxUtil.toStax2Base64Variant(base64Variant);
        try {
            if (this._nextIsAttribute) {
                byte[] byArray2 = this.toFullBuffer(byArray, n2, n3);
                this._xmlWriter.writeBinaryAttribute(base64Variant2, "", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), byArray2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBinary(base64Variant2, byArray, n2, n3);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), base64Variant2, byArray, n2, n3);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBinary(base64Variant2, byArray, n2, n3);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException {
        if (inputStream == null) {
            this.writeNull();
            return 0;
        }
        this._verifyValueWrite("write Binary value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant base64Variant2 = StaxUtil.toStax2Base64Variant(base64Variant);
        try {
            if (this._nextIsAttribute) {
                byte[] byArray = this.toFullBuffer(inputStream, n2);
                this._xmlWriter.writeBinaryAttribute(base64Variant2, "", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), byArray);
            } else if (this.checkNextIsUnwrapped()) {
                this.writeStreamAsBinary(base64Variant2, inputStream, n2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), base64Variant2, this.toFullBuffer(inputStream, n2), 0, n2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this.writeStreamAsBinary(base64Variant2, inputStream, n2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
        return n2;
    }

    private void writeStreamAsBinary(com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException, XMLStreamException {
        int n3;
        byte[] byArray = new byte[3];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray, n4, Math.min(3 - n4, n2))) != -1) {
            n2 -= n3;
            if ((n4 += n3) == 3) {
                n4 = 0;
                this._xmlWriter.writeBinary(base64Variant, byArray, 0, 3);
            }
            if (n2 != 0) continue;
        }
        if (n4 > 0) {
            this._xmlWriter.writeBinary(base64Variant, byArray, 0, n4);
        }
    }

    private byte[] toFullBuffer(byte[] byArray, int n2, int n3) {
        if (n2 == 0 && n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        if (n3 > 0) {
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        return byArray2;
    }

    private byte[] toFullBuffer(InputStream inputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = inputStream.read(byArray, i2, n2 - i2);
            if (n3 >= 0) continue;
            this._reportError("Too few bytes available: missing " + (n2 - i2) + " bytes (out of " + n2 + ")");
        }
        return byArray;
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeBooleanAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bl2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBoolean(bl2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bl2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBoolean(bl2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (!this._nextIsAttribute && !this.checkNextIsUnwrapped()) {
                boolean bl2 = this.isEnabled(Feature.WRITE_NULLS_AS_XSI_NIL);
                if (this._xmlPrettyPrinter != null) {
                    if (bl2 && this._xmlPrettyPrinter instanceof DefaultXmlPrettyPrinter) {
                        ((DefaultXmlPrettyPrinter)this._xmlPrettyPrinter).writeLeafXsiNilElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    } else {
                        this._xmlPrettyPrinter.writeLeafNullElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    }
                } else if (bl2) {
                    this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    this._xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                    this._xmlWriter.writeEndElement();
                } else {
                    this._xmlWriter.writeEmptyElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(int n2) throws IOException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), n2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInt(n2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), n2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInt(n2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(long l2) throws IOException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeLongAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeLong(l2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeLong(l2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(double d2) throws IOException {
        if (Double.isInfinite(d2) && this.isEnabled(Feature.WRITE_XML_SCHEMA_CONFORMING_FLOATS)) {
            this.writeNumber(d2 > 0.0 ? "INF" : "-INF");
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeDoubleAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeDouble(d2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeDouble(d2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(float f2) throws IOException {
        if (Float.isInfinite(f2) && this.isEnabled(Feature.WRITE_XML_SCHEMA_CONFORMING_FLOATS)) {
            this.writeNumber(f2 > 0.0f ? "INF" : "-INF");
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeFloatAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeFloat(f2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeFloat(f2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        boolean bl2 = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        try {
            if (this._nextIsAttribute) {
                if (bl2) {
                    this._xmlWriter.writeAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal.toPlainString());
                } else {
                    this._xmlWriter.writeDecimalAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal);
                }
            } else if (this.checkNextIsUnwrapped()) {
                if (bl2) {
                    this._xmlWriter.writeCharacters(bigDecimal.toPlainString());
                } else {
                    this._xmlWriter.writeDecimal(bigDecimal);
                }
            } else if (this._xmlPrettyPrinter != null) {
                if (bl2) {
                    this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal.toPlainString(), false);
                } else {
                    this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal);
                }
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (bl2) {
                    this._xmlWriter.writeCharacters(bigDecimal.toPlainString());
                } else {
                    this._xmlWriter.writeDecimal(bigDecimal);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntegerAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigInteger);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInteger(bigInteger);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigInteger);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInteger(bigInteger);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsGenerationException(xMLStreamException, this);
        }
    }

    @Override
    public void writeNumber(String string) throws IOException, UnsupportedOperationException {
        this.writeString(string);
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException {
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._xmlWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, this);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
                try {
                    while (true) {
                        JsonWriteContext jsonWriteContext;
                        if ((jsonWriteContext = this._writeContext).inArray()) {
                            this.writeEndArray();
                            continue;
                        }
                        if (jsonWriteContext.inObject()) {
                            this.writeEndObject();
                            continue;
                        }
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new JsonGenerationException(arrayIndexOutOfBoundsException, (JsonGenerator)this);
                }
            }
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                    this._xmlWriter.closeCompletely();
                } else {
                    this._xmlWriter.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, this);
            }
            super.close();
        }
    }

    @Override
    protected void _releaseBuffers() {
    }

    protected boolean checkNextIsUnwrapped() {
        if (this._nextIsUnwrapped) {
            this._nextIsUnwrapped = false;
            return true;
        }
        return false;
    }

    protected void handleMissingName() {
        throw new IllegalStateException("No element/attribute name specified when trying to output element");
    }

    protected void _reportUnimplementedStax2(String string) throws IOException {
        throw new JsonGenerationException("Underlying Stax XMLStreamWriter (of type " + this._originalXmlWriter.getClass().getName() + ") does not implement Stax2 API natively and is missing method '" + string + "': this breaks functionality such as indentation that relies on it. You need to upgrade to using compliant Stax implementation like Woodstox or Aalto", (JsonGenerator)this);
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_XML_DECLARATION(false),
        WRITE_XML_1_1(false),
        WRITE_NULLS_AS_XSI_NIL(false),
        UNWRAP_ROOT_OBJECT_NODE(false),
        AUTO_DETECT_XSI_TYPE(false),
        WRITE_XML_SCHEMA_CONFORMING_FLOATS(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }
    }
}

