/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.time.Month;
import java.util.regex.Pattern;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    private static final Pattern HAS_ONE_OR_TWO_DIGITS = Pattern.compile("^\\d{1,2}$");

    public OneBasedMonthDeserializer(JsonDeserializer<?> jsonDeserializer) {
        super(jsonDeserializer);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        Month month = (Month)this.getDelegatee().deserialize(jsonParser, deserializationContext);
        if (!this._isNumericValue(jsonParser.getText(), jsonToken)) {
            return month;
        }
        if (month == Month.JANUARY) {
            throw new InvalidFormatException(jsonParser, "Month.JANUARY value not allowed for 1-based Month.", month, Month.class);
        }
        return month.minus(1L);
    }

    private boolean _isNumericValue(String string, JsonToken jsonToken) {
        return jsonToken == JsonToken.VALUE_NUMBER_INT || this._isNumberAsString(string, jsonToken);
    }

    private boolean _isNumberAsString(String string, JsonToken jsonToken) {
        return jsonToken == JsonToken.VALUE_STRING && HAS_ONE_OR_TWO_DIGITS.matcher(string).matches();
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        return new OneBasedMonthDeserializer(jsonDeserializer);
    }
}

