/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class Enums {
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> enumConstantCache = new WeakHashMap();

    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> clazz, String string) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(string);
        return Platform.getEnumIfPresent(clazz, string);
    }

    private static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> populateCache(Class<T> clazz) {
        HashMap hashMap = new HashMap();
        for (Enum enum_ : EnumSet.allOf(clazz)) {
            hashMap.put(enum_.name(), new WeakReference<Enum>(enum_));
        }
        enumConstantCache.put(clazz, hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> getEnumConstants(Class<T> clazz) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = enumConstantCache;
        synchronized (map) {
            Map<String, WeakReference<Enum>> map2 = enumConstantCache.get(clazz);
            if (map2 == null) {
                map2 = Enums.populateCache(clazz);
            }
            return map2;
        }
    }
}

