/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Booleans {
    public static int hashCode(boolean bl2) {
        return bl2 ? 1231 : 1237;
    }

    private static int indexOf(boolean[] blArray, boolean bl2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (blArray[i2] != bl2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(boolean[] blArray, boolean bl2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (blArray[i2] != bl2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Boolean> asList(boolean ... blArray) {
        if (blArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(blArray);
    }

    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements Serializable,
    RandomAccess {
        final boolean[] array;
        final int start;
        final int end;

        BooleanArrayAsList(boolean[] blArray) {
            this(blArray, 0, blArray.length);
        }

        BooleanArrayAsList(boolean[] blArray, int n2, int n3) {
            this.array = blArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Boolean get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Boolean && Booleans.indexOf(this.array, (Boolean)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.indexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.lastIndexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int n2, Boolean bl2) {
            Preconditions.checkElementIndex(n2, this.size());
            boolean bl3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(bl2);
            return bl3;
        }

        @Override
        public List<Boolean> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList booleanArrayAsList = (BooleanArrayAsList)object;
                int n2 = this.size();
                if (booleanArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == booleanArrayAsList.array[booleanArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Booleans.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 7);
            stringBuilder.append(this.array[this.start] ? "[true" : "[false");
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(this.array[i2] ? ", true" : ", false");
            }
            return stringBuilder.append(']').toString();
        }
    }
}

