/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.reflect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Joiner;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Predicate;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.FluentIterable;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ForwardingSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Primitives;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.Invokable;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeCapture;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeParameter;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeResolver;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeVisitor;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.Types;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType;
    private transient TypeResolver invariantTypeResolver;
    private transient TypeResolver covariantTypeResolver;
    private static final long serialVersionUID = 3637540370352322684L;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", this.runtimeType);
    }

    protected TypeToken(Class<?> clazz) {
        Type type = super.capture();
        this.runtimeType = type instanceof Class ? type : TypeResolver.covariantly(clazz).resolveType(type);
    }

    private TypeToken(Type type) {
        this.runtimeType = Preconditions.checkNotNull(type);
    }

    public static <T> TypeToken<T> of(Class<T> clazz) {
        return new SimpleTypeToken((Type)clazz);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public final Class<? super T> getRawType() {
        Class clazz;
        Class clazz2 = clazz = (Class)this.getRawTypes().iterator().next();
        return clazz2;
    }

    public final Type getType() {
        return this.runtimeType;
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, TypeToken<X> typeToken) {
        TypeResolver typeResolver = new TypeResolver().where(ImmutableMap.of(new TypeResolver.TypeVariableKey(typeParameter.typeVariable), typeToken.runtimeType));
        return new SimpleTypeToken(typeResolver.resolveType(this.runtimeType));
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, Class<X> clazz) {
        return this.where(typeParameter, TypeToken.of(clazz));
    }

    public final TypeToken<?> resolveType(Type type) {
        Preconditions.checkNotNull(type);
        return TypeToken.of(this.getInvariantTypeResolver().resolveType(type));
    }

    private TypeToken<?> resolveSupertype(Type type) {
        TypeToken<?> typeToken = TypeToken.of(this.getCovariantTypeResolver().resolveType(type));
        typeToken.covariantTypeResolver = this.covariantTypeResolver;
        typeToken.invariantTypeResolver = this.invariantTypeResolver;
        return typeToken;
    }

    final TypeToken<? super T> getGenericSuperclass() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)this.runtimeType).getBounds()[0]);
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)this.runtimeType).getUpperBounds()[0]);
        }
        Type type = this.getRawType().getGenericSuperclass();
        if (type == null) {
            return null;
        }
        TypeToken<?> typeToken = this.resolveSupertype(type);
        return typeToken;
    }

    private TypeToken<? super T> boundAsSuperclass(Type type) {
        TypeToken<?> typeToken = TypeToken.of(type);
        if (typeToken.getRawType().isInterface()) {
            return null;
        }
        TypeToken<?> typeToken2 = typeToken;
        return typeToken2;
    }

    final ImmutableList<TypeToken<? super T>> getGenericInterfaces() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)this.runtimeType).getUpperBounds());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : this.getRawType().getGenericInterfaces()) {
            TypeToken<?> typeToken = this.resolveSupertype(type);
            builder.add(typeToken);
        }
        return builder.build();
    }

    private ImmutableList<TypeToken<? super T>> boundsAsInterfaces(Type[] typeArray) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : typeArray) {
            TypeToken<?> typeToken = TypeToken.of(type);
            if (!typeToken.getRawType().isInterface()) continue;
            builder.add(typeToken);
        }
        return builder.build();
    }

    public final TypeSet getTypes() {
        return new TypeSet();
    }

    public final TypeToken<? super T> getSupertype(Class<? super T> clazz) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(clazz), "%s is not a super class of %s", clazz, this);
        if (this.runtimeType instanceof TypeVariable) {
            return this.getSupertypeFromUpperBounds(clazz, ((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.getSupertypeFromUpperBounds(clazz, ((WildcardType)this.runtimeType).getUpperBounds());
        }
        if (clazz.isArray()) {
            return this.getArraySupertype(clazz);
        }
        TypeToken<?> typeToken = this.resolveSupertype(TypeToken.toGenericType(clazz).runtimeType);
        return typeToken;
    }

    public final TypeToken<? extends T> getSubtype(Class<?> clazz) {
        Preconditions.checkArgument(!(this.runtimeType instanceof TypeVariable), "Cannot get subtype of type variable <%s>", this);
        if (this.runtimeType instanceof WildcardType) {
            return this.getSubtypeFromLowerBounds(clazz, ((WildcardType)this.runtimeType).getLowerBounds());
        }
        if (this.isArray()) {
            return this.getArraySubtype(clazz);
        }
        Preconditions.checkArgument(this.getRawType().isAssignableFrom(clazz), "%s isn't a subclass of %s", clazz, this);
        Type type = this.resolveTypeArgsForSubclass(clazz);
        TypeToken<?> typeToken = TypeToken.of(type);
        Preconditions.checkArgument(typeToken.isSubtypeOf(this), "%s does not appear to be a subtype of %s", typeToken, this);
        return typeToken;
    }

    public final boolean isSupertypeOf(TypeToken<?> typeToken) {
        return typeToken.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeToken.of(type).isSubtypeOf(this.getType());
    }

    public final boolean isSubtypeOf(TypeToken<?> typeToken) {
        return this.isSubtypeOf(typeToken.getType());
    }

    public final boolean isSubtypeOf(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof WildcardType) {
            return TypeToken.any(((WildcardType)type).getLowerBounds()).isSupertypeOf(this.runtimeType);
        }
        if (this.runtimeType instanceof WildcardType) {
            return TypeToken.any(((WildcardType)this.runtimeType).getUpperBounds()).isSubtypeOf(type);
        }
        if (this.runtimeType instanceof TypeVariable) {
            return this.runtimeType.equals(type) || TypeToken.any(((TypeVariable)this.runtimeType).getBounds()).isSubtypeOf(type);
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return super.isSupertypeOfArray((GenericArrayType)this.runtimeType);
        }
        if (type instanceof Class) {
            return this.someRawTypeIsSubclassOf((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.isSubtypeOfParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.isSubtypeOfArrayType((GenericArrayType)type);
        }
        return false;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final boolean isPrimitive() {
        return this.runtimeType instanceof Class && ((Class)this.runtimeType).isPrimitive();
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.wrap(clazz));
        }
        return this;
    }

    private boolean isWrapper() {
        return Primitives.allWrapperTypes().contains(this.runtimeType);
    }

    public final TypeToken<T> unwrap() {
        if (this.isWrapper()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.unwrap(clazz));
        }
        return this;
    }

    public final TypeToken<?> getComponentType() {
        Type type = Types.getComponentType(this.runtimeType);
        if (type == null) {
            return null;
        }
        return TypeToken.of(type);
    }

    public final Invokable<T, Object> method(Method method) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(method.getDeclaringClass()), "%s not declared by %s", method, this);
        return new Invokable.MethodInvokable<T>(method){

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                return this.getOwnerType() + "." + super.toString();
            }
        };
    }

    public final Invokable<T, T> constructor(Constructor<?> constructor) {
        Preconditions.checkArgument(constructor.getDeclaringClass() == this.getRawType(), "%s not declared by %s", constructor, this.getRawType());
        return new Invokable.ConstructorInvokable<T>(constructor){

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                return this.getOwnerType() + "(" + Joiner.on(", ").join(this.getGenericParameterTypes()) + ")";
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof TypeToken) {
            TypeToken typeToken = (TypeToken)object;
            return this.runtimeType.equals(typeToken.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    protected Object writeReplace() {
        return TypeToken.of(new TypeResolver().resolveType(this.runtimeType));
    }

    final TypeToken<T> rejectTypeVariables() {
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                throw new IllegalArgumentException(TypeToken.this.runtimeType + "contains a type variable and is not safe for the operation");
            }

            @Override
            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getLowerBounds());
                this.visit(wildcardType.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType parameterizedType) {
                this.visit(parameterizedType.getActualTypeArguments());
                this.visit(parameterizedType.getOwnerType());
            }

            @Override
            void visitGenericArrayType(GenericArrayType genericArrayType) {
                this.visit(genericArrayType.getGenericComponentType());
            }
        }.visit(this.runtimeType);
        return this;
    }

    private boolean someRawTypeIsSubclassOf(Class<?> clazz) {
        for (Class clazz2 : this.getRawTypes()) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfParameterizedType(ParameterizedType parameterizedType) {
        Class<?> clazz = TypeToken.of(parameterizedType).getRawType();
        if (!this.someRawTypeIsSubclassOf(clazz)) {
            return false;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            Type type = this.getCovariantTypeResolver().resolveType(typeVariableArray[i2]);
            if (super.is(typeArray[i2], typeVariableArray[i2])) continue;
            return false;
        }
        return Modifier.isStatic(((Class)parameterizedType.getRawType()).getModifiers()) || parameterizedType.getOwnerType() == null || this.isOwnedBySubtypeOf(parameterizedType.getOwnerType());
    }

    private boolean isSubtypeOfArrayType(GenericArrayType genericArrayType) {
        if (this.runtimeType instanceof Class) {
            Class clazz = (Class)this.runtimeType;
            if (!clazz.isArray()) {
                return false;
            }
            return TypeToken.of(clazz.getComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            GenericArrayType genericArrayType2 = (GenericArrayType)this.runtimeType;
            return TypeToken.of(genericArrayType2.getGenericComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    private boolean isSupertypeOfArray(GenericArrayType genericArrayType) {
        if (this.runtimeType instanceof Class) {
            Class clazz = (Class)this.runtimeType;
            if (!clazz.isArray()) {
                return clazz.isAssignableFrom(Object[].class);
            }
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(clazz.getComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.runtimeType).getGenericComponentType());
        }
        return false;
    }

    private boolean is(Type type, TypeVariable<?> typeVariable) {
        if (this.runtimeType.equals(type)) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)type);
            return TypeToken.every(wildcardType.getUpperBounds()).isSupertypeOf(this.runtimeType) && TypeToken.every(wildcardType.getLowerBounds()).isSubtypeOf(this.runtimeType);
        }
        return TypeToken.canonicalizeWildcardsInType(this.runtimeType).equals(TypeToken.canonicalizeWildcardsInType(type));
    }

    private static Type canonicalizeTypeArg(TypeVariable<?> typeVariable, Type type) {
        return type instanceof WildcardType ? TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)type) : TypeToken.canonicalizeWildcardsInType(type);
    }

    private static Type canonicalizeWildcardsInType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.canonicalizeWildcardsInParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return Types.newArrayType(TypeToken.canonicalizeWildcardsInType(((GenericArrayType)type).getGenericComponentType()));
        }
        return type;
    }

    private static WildcardType canonicalizeWildcardType(TypeVariable<?> typeVariable, WildcardType wildcardType) {
        Type[] typeArray = typeVariable.getBounds();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type type : wildcardType.getUpperBounds()) {
            if (TypeToken.any(typeArray).isSubtypeOf(type)) continue;
            arrayList.add(TypeToken.canonicalizeWildcardsInType(type));
        }
        return new Types.WildcardTypeImpl(wildcardType.getLowerBounds(), arrayList.toArray(new Type[0]));
    }

    private static ParameterizedType canonicalizeWildcardsInParameterizedType(ParameterizedType parameterizedType) {
        Class clazz = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = TypeToken.canonicalizeTypeArg(typeVariableArray[i2], typeArray[i2]);
        }
        return Types.newParameterizedTypeWithOwner(parameterizedType.getOwnerType(), clazz, typeArray);
    }

    private static Bounds every(Type[] typeArray) {
        return new Bounds(typeArray, false);
    }

    private static Bounds any(Type[] typeArray) {
        return new Bounds(typeArray, true);
    }

    private ImmutableSet<Class<? super T>> getRawTypes() {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        new TypeVisitor(this){
            final /* synthetic */ TypeToken this$0;
            {
                this.this$0 = typeToken;
            }

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                this.visit(typeVariable.getBounds());
            }

            @Override
            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType parameterizedType) {
                builder.add((Class)parameterizedType.getRawType());
            }

            @Override
            void visitClass(Class<?> clazz) {
                builder.add(clazz);
            }

            @Override
            void visitGenericArrayType(GenericArrayType genericArrayType) {
                builder.add(Types.getArrayClass(TypeToken.of(genericArrayType.getGenericComponentType()).getRawType()));
            }
        }.visit(this.runtimeType);
        ImmutableSet<Class<? super T>> immutableSet = builder.build();
        return immutableSet;
    }

    private boolean isOwnedBySubtypeOf(Type type) {
        for (TypeToken typeToken : this.getTypes()) {
            Type type2 = typeToken.getOwnerTypeIfPresent();
            if (type2 == null || !TypeToken.of(type2).isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    private Type getOwnerTypeIfPresent() {
        if (this.runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)this.runtimeType).getOwnerType();
        }
        if (this.runtimeType instanceof Class) {
            return ((Class)this.runtimeType).getEnclosingClass();
        }
        return null;
    }

    static <T> TypeToken<? extends T> toGenericType(Class<T> clazz) {
        Type type;
        if (clazz.isArray()) {
            Type type2 = Types.newArrayType(TypeToken.toGenericType(clazz.getComponentType()).runtimeType);
            TypeToken<?> typeToken = TypeToken.of(type2);
            return typeToken;
        }
        Type[] typeArray = clazz.getTypeParameters();
        Type type3 = type = clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) ? TypeToken.toGenericType(clazz.getEnclosingClass()).runtimeType : null;
        if (typeArray.length > 0 || type != null && type != clazz.getEnclosingClass()) {
            TypeToken<?> typeToken = TypeToken.of(Types.newParameterizedTypeWithOwner(type, clazz, typeArray));
            return typeToken;
        }
        return TypeToken.of(clazz);
    }

    private TypeResolver getCovariantTypeResolver() {
        TypeResolver typeResolver = this.covariantTypeResolver;
        if (typeResolver == null) {
            typeResolver = this.covariantTypeResolver = TypeResolver.covariantly(this.runtimeType);
        }
        return typeResolver;
    }

    private TypeResolver getInvariantTypeResolver() {
        TypeResolver typeResolver = this.invariantTypeResolver;
        if (typeResolver == null) {
            typeResolver = this.invariantTypeResolver = TypeResolver.invariantly(this.runtimeType);
        }
        return typeResolver;
    }

    private TypeToken<? super T> getSupertypeFromUpperBounds(Class<? super T> clazz, Type[] typeArray) {
        for (Type type : typeArray) {
            TypeToken<?> typeToken = TypeToken.of(type);
            if (!typeToken.isSubtypeOf(clazz)) continue;
            TypeToken<? super T> typeToken2 = typeToken.getSupertype(clazz);
            return typeToken2;
        }
        throw new IllegalArgumentException(clazz + " isn't a super type of " + this);
    }

    private TypeToken<? extends T> getSubtypeFromLowerBounds(Class<?> clazz, Type[] typeArray) {
        if (typeArray.length > 0) {
            TypeToken<?> typeToken = TypeToken.of(typeArray[0]);
            return typeToken.getSubtype(clazz);
        }
        throw new IllegalArgumentException(clazz + " isn't a subclass of " + this);
    }

    private TypeToken<? super T> getArraySupertype(Class<? super T> clazz) {
        TypeToken<?> typeToken = this.getComponentType();
        if (typeToken == null) {
            throw new IllegalArgumentException(clazz + " isn't a super type of " + this);
        }
        TypeToken<?> typeToken2 = typeToken.getSupertype(Objects.requireNonNull(clazz.getComponentType()));
        TypeToken<?> typeToken3 = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(typeToken2.runtimeType));
        return typeToken3;
    }

    private TypeToken<? extends T> getArraySubtype(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new IllegalArgumentException(clazz + " does not appear to be a subtype of " + this);
        }
        TypeToken<?> typeToken = Objects.requireNonNull(this.getComponentType()).getSubtype(clazz2);
        TypeToken<?> typeToken2 = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(typeToken.runtimeType));
        return typeToken2;
    }

    private Type resolveTypeArgsForSubclass(Class<?> clazz) {
        if (this.runtimeType instanceof Class && (clazz.getTypeParameters().length == 0 || this.getRawType().getTypeParameters().length != 0)) {
            return clazz;
        }
        TypeToken<?> typeToken = TypeToken.toGenericType(clazz);
        Type type = typeToken.getSupertype(this.getRawType()).runtimeType;
        return new TypeResolver().where(type, this.runtimeType).resolveType(typeToken.runtimeType);
    }

    private static Type newArrayClassOrGenericArrayType(Type type) {
        return Types.JavaVersion.JAVA7.newArrayType(type);
    }

    static /* synthetic */ TypeResolver access$000(TypeToken typeToken) {
        return typeToken.getCovariantTypeResolver();
    }

    static /* synthetic */ ImmutableSet access$300(TypeToken typeToken) {
        return typeToken.getRawTypes();
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        SimpleTypeToken(Type type) {
            super(type);
        }
    }

    public class TypeSet
    extends ForwardingSet<TypeToken<? super T>>
    implements Serializable {
        private transient ImmutableSet<TypeToken<? super T>> types;

        TypeSet() {
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet = this.types;
            if (immutableSet == null) {
                ImmutableList<TypeToken> immutableList = TypeCollector.FOR_GENERIC_TYPE.collectTypes(TypeToken.this);
                this.types = FluentIterable.from(immutableList).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                return this.types;
            }
            return immutableSet;
        }
    }

    private static class Bounds {
        private final Type[] bounds;
        private final boolean target;

        Bounds(Type[] typeArray, boolean bl2) {
            this.bounds = typeArray;
            this.target = bl2;
        }

        boolean isSubtypeOf(Type type) {
            for (Type type2 : this.bounds) {
                if (TypeToken.of(type2).isSubtypeOf(type) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }

        boolean isSupertypeOf(Type type) {
            TypeToken<?> typeToken = TypeToken.of(type);
            for (Type type2 : this.bounds) {
                if (typeToken.isSubtypeOf(type2) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }
    }

    private static abstract class TypeCollector<K> {
        static final TypeCollector<TypeToken<?>> FOR_GENERIC_TYPE = new TypeCollector<TypeToken<?>>(){

            @Override
            Class<?> getRawType(TypeToken<?> typeToken) {
                return typeToken.getRawType();
            }

            @Override
            Iterable<? extends TypeToken<?>> getInterfaces(TypeToken<?> typeToken) {
                return typeToken.getGenericInterfaces();
            }

            @Override
            TypeToken<?> getSuperclass(TypeToken<?> typeToken) {
                return typeToken.getGenericSuperclass();
            }
        };
        static final TypeCollector<Class<?>> FOR_RAW_TYPE = new TypeCollector<Class<?>>(){

            @Override
            Class<?> getRawType(Class<?> clazz) {
                return clazz;
            }

            @Override
            Iterable<? extends Class<?>> getInterfaces(Class<?> clazz) {
                return Arrays.asList(clazz.getInterfaces());
            }

            @Override
            Class<?> getSuperclass(Class<?> clazz) {
                return clazz.getSuperclass();
            }
        };

        private TypeCollector() {
        }

        final ImmutableList<K> collectTypes(K k2) {
            return this.collectTypes((Iterable<? extends K>)ImmutableList.of(k2));
        }

        ImmutableList<K> collectTypes(Iterable<? extends K> iterable) {
            HashMap hashMap = Maps.newHashMap();
            for (K k2 : iterable) {
                this.collectTypes(k2, hashMap);
            }
            return TypeCollector.sortKeysByValue(hashMap, Ordering.natural().reverse());
        }

        private int collectTypes(K k2, Map<? super K, Integer> map) {
            Integer n2 = map.get(k2);
            if (n2 != null) {
                return n2;
            }
            int n3 = this.getRawType(k2).isInterface() ? 1 : 0;
            for (K k3 : this.getInterfaces(k2)) {
                n3 = Math.max(n3, this.collectTypes(k3, map));
            }
            Iterator<K> iterator = this.getSuperclass(k2);
            if (iterator != null) {
                n3 = Math.max(n3, this.collectTypes(iterator, map));
            }
            map.put(k2, n3 + 1);
            return n3 + 1;
        }

        private static <K, V> ImmutableList<K> sortKeysByValue(final Map<K, V> map, final Comparator<? super V> comparator) {
            Ordering ordering = new Ordering<K>(){

                @Override
                public int compare(K k2, K k3) {
                    return comparator.compare(Objects.requireNonNull(map.get(k2)), Objects.requireNonNull(map.get(k3)));
                }
            };
            return ordering.immutableSortedCopy(map.keySet());
        }

        abstract Class<?> getRawType(K var1);

        abstract Iterable<? extends K> getInterfaces(K var1);

        abstract K getSuperclass(K var1);
    }

    private static enum TypeFilter implements Predicate<TypeToken<?>>
    {
        IGNORE_TYPE_VARIABLE_OR_WILDCARD{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                return !(((TypeToken)typeToken).runtimeType instanceof TypeVariable) && !(((TypeToken)typeToken).runtimeType instanceof WildcardType);
            }
        }
        ,
        INTERFACE_ONLY{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                return typeToken.getRawType().isInterface();
            }
        };

    }
}

