/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ErrorHandler;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.JavaClassContext;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.JavaLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.ParseException;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.Parser;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class SourceLibrary
extends AbstractClassLibrary {
    private JavaClassContext context = new JavaClassContext();
    private boolean debugLexer;
    private boolean debugParser;
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private ErrorHandler errorHandler;

    public SourceLibrary(AbstractClassLibrary abstractClassLibrary) {
        super(abstractClassLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Builder parse(Reader reader, URL uRL) throws ParseException {
        try {
            Builder builder = this.parse(new JFlexLexer(reader), uRL);
            return builder;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Builder parse(JavaLexer javaLexer, URL uRL) throws ParseException {
        Builder builder = this.getModelBuilder();
        builder.setUrl(uRL);
        Parser parser = new Parser(javaLexer, builder);
        parser.setDebugLexer(this.debugLexer);
        parser.setDebugParser(this.debugParser);
        try {
            if (parser.parse()) {
                return builder;
            }
        }
        catch (ParseException parseException) {
            if (uRL != null) {
                parseException.setSourceInfo(uRL.toExternalForm());
            }
            if (this.errorHandler != null) {
                this.errorHandler.handle(parseException);
            }
            throw parseException;
        }
        return null;
    }

    @Override
    protected JavaClass resolveJavaClass(String string) {
        return this.context.removeClassByName(string);
    }

    @Override
    protected JavaPackage resolveJavaPackage(String string) {
        return this.context.removePackageByName(string);
    }

    @Override
    protected boolean containsClassReference(String string) {
        return this.context.getClassByName(string) != null;
    }
}

