/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufHolder;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;

public class DefaultByteBufHolder
implements ByteBufHolder {
    private final ByteBuf data;

    public DefaultByteBufHolder(ByteBuf byteBuf) {
        this.data = ObjectUtil.checkNotNull(byteBuf, "data");
    }

    @Override
    public ByteBuf content() {
        return ByteBufUtil.ensureAccessible(this.data);
    }

    @Override
    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public ByteBufHolder retain() {
        this.data.retain();
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        this.data.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object object) {
        this.data.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.data.release();
    }

    protected final String contentToString() {
        return this.data.toString();
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.contentToString() + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return this.data.equals(((DefaultByteBufHolder)object).data);
        }
        return false;
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

