/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.CompositeByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.LongCounter;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator {
    private final UnpooledByteBufAllocatorMetric metric = new UnpooledByteBufAllocatorMetric();
    private final boolean disableLeakDetector;
    private final boolean noCleaner;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl2) {
        this(bl2, false);
    }

    public UnpooledByteBufAllocator(boolean bl2, boolean bl3) {
        this(bl2, bl3, PlatformDependent.useDirectBufferNoCleaner());
    }

    public UnpooledByteBufAllocator(boolean bl2, boolean bl3, boolean bl4) {
        super(bl2);
        this.disableLeakDetector = bl3;
        this.noCleaner = bl4 && PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor();
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        return PlatformDependent.hasUnsafe() ? new InstrumentedUnpooledUnsafeHeapByteBuf(this, n2, n3) : new InstrumentedUnpooledHeapByteBuf(this, n2, n3);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        UnpooledDirectByteBuf unpooledDirectByteBuf = PlatformDependent.hasUnsafe() ? (this.noCleaner ? new InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(this, n2, n3) : new InstrumentedUnpooledUnsafeDirectByteBuf(this, n2, n3)) : new InstrumentedUnpooledDirectByteBuf(this, n2, n3);
        return this.disableLeakDetector ? unpooledDirectByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(unpooledDirectByteBuf);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n2);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n2);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }

    void incrementDirect(int n2) {
        this.metric.directCounter.add(n2);
    }

    void decrementDirect(int n2) {
        this.metric.directCounter.add(-n2);
    }

    void incrementHeap(int n2) {
        this.metric.heapCounter.add(n2);
    }

    void decrementHeap(int n2) {
        this.metric.heapCounter.add(-n2);
    }

    private static final class UnpooledByteBufAllocatorMetric {
        final LongCounter directCounter = PlatformDependent.newLongCounter();
        final LongCounter heapCounter = PlatformDependent.newLongCounter();

        private UnpooledByteBufAllocatorMetric() {
        }

        public long usedHeapMemory() {
            return this.heapCounter.value();
        }

        public long usedDirectMemory() {
            return this.directCounter.value();
        }

        public String toString() {
            return StringUtil.simpleClassName(this) + "(usedHeapMemory: " + this.usedHeapMemory() + "; usedDirectMemory: " + this.usedDirectMemory() + ')';
        }
    }

    private static final class InstrumentedUnpooledDirectByteBuf
    extends UnpooledDirectByteBuf {
        InstrumentedUnpooledDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        @Override
        protected ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        protected void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        InstrumentedUnpooledUnsafeDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        @Override
        protected ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        protected void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf
    extends UnpooledUnsafeNoCleanerDirectByteBuf {
        InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        @Override
        protected ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        ByteBuffer reallocateDirect(ByteBuffer byteBuffer, int n2) {
            int n3 = byteBuffer.capacity();
            ByteBuffer byteBuffer2 = super.reallocateDirect(byteBuffer, n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer2.capacity() - n3);
            return byteBuffer2;
        }

        @Override
        protected void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledHeapByteBuf
    extends UnpooledHeapByteBuf {
        InstrumentedUnpooledHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n2, n3);
        }

        @Override
        protected byte[] allocateArray(int n2) {
            byte[] byArray = super.allocateArray(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        @Override
        protected void freeArray(byte[] byArray) {
            int n2 = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)this.alloc()).decrementHeap(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeHeapByteBuf
    extends UnpooledUnsafeHeapByteBuf {
        InstrumentedUnpooledUnsafeHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n2, n3);
        }

        @Override
        protected byte[] allocateArray(int n2) {
            byte[] byArray = super.allocateArray(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        @Override
        protected void freeArray(byte[] byArray) {
            int n2 = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)this.alloc()).decrementHeap(n2);
        }
    }
}

