/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.embedded;

import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInitializer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelMetadata;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.EventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.embedded.EmbeddedChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.channel.embedded.EmbeddedEventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.embedded.EmbeddedSocketAddress;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            EmbeddedChannel.this.recordException(channelFuture);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;
    private int executingStackCnt;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(channelId, true, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, boolean bl3, ChannelHandler ... channelHandlerArray) {
        this(null, channelId, bl2, bl3, channelHandlerArray);
    }

    public EmbeddedChannel(Channel channel, ChannelId channelId, boolean bl2, boolean bl3, ChannelHandler ... channelHandlerArray) {
        super(channel, channelId);
        this.metadata = EmbeddedChannel.metadata(bl3);
        this.config = new DefaultChannelConfig(this);
        this.setup(bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl2);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(true, channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl2) {
        return bl2 ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean bl2, final ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline channelPipeline = channel.pipeline();
                for (ChannelHandler channelHandler : channelHandlerArray) {
                    if (channelHandler == null) break;
                    channelPipeline.addLast(channelHandler);
                }
            }
        });
        if (bl2) {
            ChannelFuture channelFuture = this.loop.register(this);
            assert (channelFuture.isDone());
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    public <T> T readInbound() {
        Object object = EmbeddedChannel.poll(this.inboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readInbound() will handle the message from this point");
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ++this.executingStackCnt;
        try {
            ChannelPipeline channelPipeline = this.pipeline();
            for (Object object : objectArray) {
                channelPipeline.fireChannelRead(object);
            }
            this.flushInbound(false, this.voidPromise());
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    private ChannelFuture flushInbound(boolean bl2, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(bl2)) {
                this.pipeline().fireChannelReadComplete();
                this.runPendingTasks();
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl2) {
        ++this.executingStackCnt;
        try {
            this.close();
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        try {
            this.checkException();
            boolean bl3 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl3;
        }
        finally {
            if (bl2) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl2) {
        this.runPendingTasks();
        if (bl2) {
            this.embeddedEventLoop().cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        ChannelFuture channelFuture;
        ++this.executingStackCnt;
        try {
            this.runPendingTasks();
            channelFuture = super.close(channelPromise);
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture;
        ++this.executingStackCnt;
        try {
            channelFuture = super.disconnect(channelPromise);
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return channelFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.bind(socketAddress, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress, socketAddress2, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.deregister(channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public Channel read() {
        ++this.executingStackCnt;
        try {
            Channel channel = super.read();
            return channel;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.write(object);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.write(object, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.writeAndFlush(object);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    private void maybeRunPendingTasks() {
        if (this.executingStackCnt == 0) {
            this.runPendingTasks();
        }
    }

    public void runPendingTasks() {
        try {
            this.embeddedEventLoop().runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    private ChannelFuture checkException(ChannelPromise channelPromise) {
        Throwable throwable = this.lastException;
        if (throwable != null) {
            this.lastException = null;
            if (channelPromise.isVoid()) {
                PlatformDependent.throwException(throwable);
            }
            return channelPromise.setFailure(throwable);
        }
        return channelPromise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean bl2) {
        if (!this.isOpen()) {
            if (bl2) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        if (this.isRegistered()) {
            return (EmbeddedEventLoop)super.eventLoop();
        }
        return this.loop;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    @Override
    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.handleOutboundMessage(object);
            channelOutboundBuffer.remove();
        }
    }

    protected void handleOutboundMessage(Object object) {
        this.outboundMessages().add(object);
    }

    protected void handleInboundMessage(Object object) {
        this.inboundMessages().add(object);
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline(EmbeddedChannel embeddedChannel2) {
            super(embeddedChannel2);
        }

        @Override
        protected void onUnhandledInboundException(Throwable throwable) {
            EmbeddedChannel.this.recordException(throwable);
        }

        @Override
        protected void onUnhandledInboundMessage(ChannelHandlerContext channelHandlerContext, Object object) {
            EmbeddedChannel.this.handleInboundMessage(object);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped = new Channel.Unsafe(){

            @Override
            public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                return EmbeddedUnsafe.this.recvBufAllocHandle();
            }

            @Override
            public SocketAddress localAddress() {
                return EmbeddedUnsafe.this.localAddress();
            }

            @Override
            public SocketAddress remoteAddress() {
                return EmbeddedUnsafe.this.remoteAddress();
            }

            @Override
            public void register(EventLoop eventLoop, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.register(eventLoop, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.bind(socketAddress, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.connect(socketAddress, socketAddress2, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void disconnect(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.disconnect(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void close(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.close(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void closeForcibly() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.closeForcibly();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void deregister(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.deregister(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void beginRead() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.beginRead();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void write(Object object, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.write(object, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void flush() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.flush();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public ChannelPromise voidPromise() {
                return EmbeddedUnsafe.this.voidPromise();
            }

            @Override
            public ChannelOutboundBuffer outboundBuffer() {
                return EmbeddedUnsafe.this.outboundBuffer();
            }
        };

        private EmbeddedUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.safeSetSuccess(channelPromise);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

