/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufHolder;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.CompositeByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DecoderResult;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DecoderResultProvider;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageAggregationException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageToMessageDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.PrematureChannelClosureException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.List;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;
    private boolean handleIncompleteAggregateDuringClose = true;

    protected MessageAggregator(int n2) {
        MessageAggregator.validateMaxContentLength(n2);
        this.maxContentLength = n2;
    }

    private static void validateMaxContentLength(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object object) throws Exception {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        Object object2 = object;
        if (this.isAggregated(object2)) {
            return false;
        }
        if (this.isStartMessage(object2)) {
            return true;
        }
        return this.aggregating && this.isContentMessage(object2);
    }

    protected abstract boolean isStartMessage(I var1) throws Exception;

    protected abstract boolean isContentMessage(I var1) throws Exception;

    protected abstract boolean isLastContentMessage(C var1) throws Exception;

    protected abstract boolean isAggregated(I var1) throws Exception;

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    @Override
    protected void decode(final ChannelHandlerContext channelHandlerContext, I i2, List<Object> list) throws Exception {
        if (this.isStartMessage(i2)) {
            Object object;
            this.aggregating = true;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I i3 = i2;
            Object object2 = this.newContinueResponse(i3, this.maxContentLength, channelHandlerContext.pipeline());
            if (object2 != null) {
                object = this.continueResponseWriteListener;
                if (object == null) {
                    object = new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (!channelFuture.isSuccess()) {
                                channelHandlerContext.fireExceptionCaught(channelFuture.cause());
                            }
                        }
                    };
                    this.continueResponseWriteListener = object;
                }
                boolean bl2 = this.closeAfterContinueResponse(object2);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object2);
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2).addListener((GenericFutureListener<? extends Future<? super Void>>)object);
                if (bl2) {
                    this.handleIncompleteAggregateDuringClose = false;
                    channelFuture.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(i3, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, i3);
                return;
            }
            if (i3 instanceof DecoderResultProvider && !((DecoderResultProvider)i3).decoderResult().isSuccess()) {
                object = i3 instanceof ByteBufHolder ? this.beginAggregation(i3, ((ByteBufHolder)i3).content().retain()) : this.beginAggregation(i3, Unpooled.EMPTY_BUFFER);
                this.finishAggregation0(object);
                list.add(object);
                return;
            }
            object = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (i3 instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object, ((ByteBufHolder)i3).content());
            }
            this.currentMessage = this.beginAggregation(i3, (ByteBuf)object);
        } else if (this.isContentMessage(i2)) {
            boolean bl3;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            ByteBufHolder byteBufHolder = (ByteBufHolder)i2;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - byteBufHolder.content().readableBytes()) {
                O o2 = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o2);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, byteBufHolder.content());
            this.aggregate(this.currentMessage, byteBufHolder);
            if (byteBufHolder instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)((Object)byteBufHolder)).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl3 = true;
                } else {
                    bl3 = this.isLastContentMessage(byteBufHolder);
                }
            } else {
                bl3 = this.isLastContentMessage(byteBufHolder);
            }
            if (bl3) {
                this.finishAggregation0(this.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
        } else {
            throw new MessageAggregationException();
        }
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2) throws Exception;

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3) throws Exception;

    protected abstract boolean closeAfterContinueResponse(Object var1) throws Exception;

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1) throws Exception;

    protected abstract O beginAggregation(S var1, ByteBuf var2) throws Exception;

    protected void aggregate(O o2, C c2) throws Exception {
    }

    private void finishAggregation0(O o2) throws Exception {
        this.aggregating = false;
        this.finishAggregation(o2);
    }

    protected void finishAggregation(O o2) throws Exception {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) throws Exception {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        this.handleIncompleteAggregateDuringClose = false;
        try {
            this.handleOversizedMessage(channelHandlerContext, s2);
        }
        finally {
            ReferenceCountUtil.release(s2);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) throws Exception {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.aggregating && this.handleIncompleteAggregateDuringClose) {
            channelHandlerContext.fireExceptionCaught(new PrematureChannelClosureException("Channel closed while still aggregating message"));
        }
        try {
            super.channelInactive(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            super.handlerRemoved(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

