/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;
import com.gradle.maven.extension.internal.dep.io.netty.util.NetUtilInitializations;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final Collection<NetworkInterface> NETWORK_INTERFACES;
    public static final int SOMAXCONN;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    /*
     * Exception decompiling
     */
    private static Integer sysctlGetInt(String var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length();
        if (n5 < 2) {
            return false;
        }
        char c2 = charSequence.charAt(0);
        if (c2 == '[') {
            if (charSequence.charAt(--n5) != ']') {
                return false;
            }
            n4 = 1;
            c2 = charSequence.charAt(1);
        } else {
            n4 = 0;
        }
        if (c2 == ':') {
            if (charSequence.charAt(n4 + 1) != ':') {
                return false;
            }
            n3 = 2;
            n2 = n4;
            n4 += 2;
        } else {
            n3 = 0;
            n2 = -1;
        }
        int n6 = 0;
        block5: for (int i2 = n4; i2 < n5; ++i2) {
            c2 = charSequence.charAt(i2);
            if (NetUtil.isValidHexChar(c2)) {
                if (n6 < 4) {
                    ++n6;
                    continue;
                }
                return false;
            }
            switch (c2) {
                case ':': {
                    if (n3 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i2 - 1) == ':') {
                        if (n2 >= 0) {
                            return false;
                        }
                        n2 = i2 - 1;
                    } else {
                        n6 = 0;
                    }
                    ++n3;
                    continue block5;
                }
                case '.': {
                    int n7;
                    if (n2 < 0 && n3 != 6 || n3 == 7 && n2 >= n4 || n3 > 7) {
                        return false;
                    }
                    int n8 = i2 - n6;
                    int n9 = n8 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 3)))) {
                            return false;
                        }
                        n9 -= 5;
                    }
                    while (n9 >= n4) {
                        n7 = charSequence.charAt(n9);
                        if (n7 != 48 && n7 != 58) {
                            return false;
                        }
                        --n9;
                    }
                    n7 = AsciiString.indexOf(charSequence, '%', n8 + 7);
                    if (n7 < 0) {
                        n7 = n5;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n8, n7);
                }
                case '%': {
                    n5 = i2;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n2 < 0) {
            return n3 == 7 && n6 > 0;
        }
        return n2 + 2 == n5 || n6 > 0 && (n3 < 8 || n2 <= n4);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n2, int n3) {
        char c2;
        int n4 = n3 - n2;
        if (n4 < 1 || n4 > 3 || (c2 = charSequence.charAt(n2)) < '0') {
            return false;
        }
        if (n4 == 3) {
            char c3;
            char c4 = charSequence.charAt(n2 + 1);
            return c4 >= '0' && (c3 = charSequence.charAt(n2 + 2)) >= '0' && (c2 <= '1' && c4 <= '9' && c3 <= '9' || c2 == '2' && c4 <= '5' && (c3 <= '5' || c4 < '5' && c3 <= '9'));
        }
        return c2 <= '9' && (n4 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n2 + 1)));
    }

    private static boolean isValidHexChar(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isValidNumericChar(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c2) {
        return c2 == 'f' || c2 == 'F';
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n2, int n3) {
        return charSequence instanceof String ? NetUtil.isValidIpV4Address((String)charSequence, n2, n3) : (charSequence instanceof AsciiString ? NetUtil.isValidIpV4Address((AsciiString)charSequence, n2, n3) : NetUtil.isValidIpV4Address0(charSequence, n2, n3));
    }

    private static boolean isValidIpV4Address(String string, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = string.indexOf(46, n2 + 1)) > 0 && NetUtil.isValidIpV4Word(string, n2, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && NetUtil.isValidIpV4Word(string, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = asciiString.indexOf('.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && NetUtil.isValidIpV4Word(asciiString, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = AsciiString.indexOf(charSequence, '.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && NetUtil.isValidIpV4Word(charSequence, n4 + 1, n3);
    }

    public static String toSocketAddressString(String string, int n2) {
        String string2 = String.valueOf(n2);
        return NetUtil.newSocketAddressStringBuilder(string, string2, !NetUtil.isValidIpV6Address(string)).append(':').append(string2).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String string, String string2, boolean bl2) {
        int n2 = string.length();
        if (bl2) {
            return new StringBuilder(n2 + 1 + string2.length()).append(string);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + 3 + string2.length());
        if (n2 > 1 && string.charAt(0) == '[' && string.charAt(n2 - 1) == ']') {
            return stringBuilder.append(string);
        }
        return stringBuilder.append('[').append(string).append(']');
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl2) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl2);
    }

    private static String toAddressString(byte[] byArray, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[8];
        for (n5 = 0; n5 < nArray.length; ++n5) {
            n4 = (n5 << 1) + n2;
            nArray[n5] = (byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
        }
        n5 = -1;
        int n6 = -1;
        int n7 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] == 0) {
                if (n5 >= 0) continue;
                n5 = n3;
                continue;
            }
            if (n5 < 0) continue;
            n4 = n3 - n5;
            if (n4 > n7) {
                n6 = n5;
                n7 = n4;
            }
            n5 = -1;
        }
        if (n5 >= 0 && (n4 = nArray.length - n5) > n7) {
            n6 = n5;
            n7 = n4;
        }
        if (n7 == 1) {
            n7 = 0;
            n6 = -1;
        }
        n3 = n6 + n7;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n3 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[i2]));
            }
        } else {
            boolean bl3;
            if (NetUtil.inRangeEndExclusive(0, n6, n3)) {
                stringBuilder.append("::");
                bl3 = bl2 && n3 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl3 = false;
            }
            for (int i3 = 1; i3 < nArray.length; ++i3) {
                if (!NetUtil.inRangeEndExclusive(i3, n6, n3)) {
                    if (!NetUtil.inRangeEndExclusive(i3 - 1, n6, n3)) {
                        if (!bl3 || i3 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl3 && i3 > 5) {
                        stringBuilder.append(nArray[i3] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[i3] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[i3]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(i3 - 1, n6, n3)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        return PlatformDependent.javaVersion() >= 7 ? inetSocketAddress.getHostString() : inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n2, int n3, int n4) {
        return n2 >= n3 && n2 < n4;
    }

    private NetUtil() {
    }

    static {
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        String string = SystemPropertyUtil.get("java.net.preferIPv6Addresses", "false");
        IPV6_ADDRESSES_PREFERRED = "true".equalsIgnoreCase(string.trim());
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)string);
        NETWORK_INTERFACES = NetUtilInitializations.networkInterfaces();
        LOCALHOST4 = NetUtilInitializations.createLocalhost4();
        LOCALHOST6 = NetUtilInitializations.createLocalhost6();
        NetUtilInitializations.NetworkIfaceAndInetAddress networkIfaceAndInetAddress = NetUtilInitializations.determineLoopback(NETWORK_INTERFACES, LOCALHOST4, LOCALHOST6);
        LOOPBACK_IF = networkIfaceAndInetAddress.iface();
        LOCALHOST = networkIfaceAndInetAddress.address();
        SOMAXCONN = AccessController.doPrivileged(new SoMaxConnAction());
    }

    private static final class SoMaxConnAction
    implements PrivilegedAction<Integer> {
        private SoMaxConnAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer run() {
            int n2 = PlatformDependent.isWindows() ? 200 : (PlatformDependent.isOsx() ? 128 : 4096);
            File file = new File("/proc/sys/net/core/somaxconn");
            BufferedReader bufferedReader = null;
            try {
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    n2 = Integer.parseInt(bufferedReader.readLine());
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: {}", (Object)file, (Object)n2);
                    }
                } else {
                    Integer n3 = null;
                    if (SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.net.somaxconn.trySysctl", false)) {
                        n3 = NetUtil.sysctlGetInt("kern.ipc.somaxconn");
                        if (n3 == null) {
                            n3 = NetUtil.sysctlGetInt("kern.ipc.soacceptqueue");
                            if (n3 != null) {
                                n2 = n3;
                            }
                        } else {
                            n2 = n3;
                        }
                    }
                    if (n3 == null) {
                        logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n2);
                    }
                }
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n2, exception);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return n2;
        }
    }
}

