/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final DoubleComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static DoubleComparator oppositeComparator(DoubleComparator doubleComparator) {
        if (doubleComparator instanceof OppositeComparator) {
            return ((OppositeComparator)doubleComparator).comparator;
        }
        return new OppositeComparator(doubleComparator);
    }

    public static DoubleComparator asDoubleComparator(final Comparator<? super Double> comparator) {
        if (comparator == null || comparator instanceof DoubleComparator) {
            return (DoubleComparator)comparator;
        }
        return new DoubleComparator(){

            @Override
            public int compare(double d2, double d3) {
                return comparator.compare(d2, d3);
            }

            @Override
            public int compare(Double d2, Double d3) {
                return comparator.compare(d2, d3);
            }
        };
    }

    protected static class OppositeComparator
    implements DoubleComparator,
    Serializable {
        final DoubleComparator comparator;

        protected OppositeComparator(DoubleComparator doubleComparator) {
            this.comparator = doubleComparator;
        }

        @Override
        public final int compare(double d2, double d3) {
            return this.comparator.compare(d3, d2);
        }

        @Override
        public final DoubleComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements DoubleComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(double d2, double d3) {
            return Double.compare(d2, d3);
        }

        @Override
        public DoubleComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements DoubleComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(double d2, double d3) {
            return -Double.compare(d2, d3);
        }

        @Override
        public DoubleComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

