/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.StandardLineSeparator;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOTriFunction;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.StringBuilderWriter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.ThresholdingOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n2) {
        return new byte[n2];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int n2) {
        return new char[n2];
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer == null) break block3;
                    iOConsumer.accept(iOException);
                }
            }
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        return l2 > Integer.MAX_VALUE ? -1 : (int)l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n2));
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, IOUtils.getScratchByteArray());
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) throws IOException {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        return IOUtils.copyLarge(reader, writer, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) throws IOException {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    private static byte[] fill0(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        return byArray;
    }

    private static char[] fill0(char[] cArray) {
        Arrays.fill(cArray, '\u0000');
        return cArray;
    }

    static byte[] getScratchByteArray() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_RW.get());
    }

    static byte[] getScratchByteArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_WO);
    }

    static char[] getScratchCharArray() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_RW.get());
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        return IOUtils.read(inputStream::read, byArray, n2, n3);
    }

    static int read(IOTriFunction<byte[], Integer, Integer, Integer> iOTriFunction, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n5 = n3; n5 > 0 && -1 != (n6 = iOTriFunction.apply(byArray, n2 + (n4 = n3 - n5), n5).intValue()); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static byte[] readFully(InputStream inputStream, int n2) throws IOException {
        byte[] byArray = IOUtils.byteArray(n2);
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static long skip(InputStream inputStream, long l2) throws IOException {
        return IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
    }

    public static long skip(InputStream inputStream, long l2, Supplier<byte[]> supplier) throws IOException {
        byte[] byArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(byArray = supplier.get(), 0, (int)Math.min(l3, (long)byArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        long l3 = IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = UnsynchronizedByteArrayOutputStream.builder().get();){
            byte[] byArray;
            try (ThresholdingOutputStream thresholdingOutputStream2 = new ThresholdingOutputStream(Integer.MAX_VALUE, thresholdingOutputStream -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, thresholdingOutputStream -> unsynchronizedByteArrayOutputStream);){
                IOUtils.copy(inputStream, thresholdingOutputStream2);
                byArray = unsynchronizedByteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public static String toString(Reader reader) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(reader, stringBuilderWriter);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }
}

