/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix;

import com.gradle.maven.extension.internal.dep.oshi.driver.unix.aix.Lscfg;
import com.gradle.maven.extension.internal.dep.oshi.driver.unix.aix.perfstat.PerfstatDisk;
import com.gradle.maven.extension.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.hardware.ComputerSystem;
import com.gradle.maven.extension.internal.dep.oshi.hardware.GlobalMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.HWDiskStore;
import com.gradle.maven.extension.internal.dep.oshi.hardware.NetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.hardware.Sensors;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixCentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixComputerSystem;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixGlobalMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixHWDiskStore;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixNetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.aix.AixSensors;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.List;
import java.util.function.Supplier;

public final class AixHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    private final Supplier<List<String>> lscfg = Memoizer.memoize(Lscfg::queryAllDevices, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats = Memoizer.memoize(PerfstatDisk::queryDiskStats, Memoizer.defaultExpiration());

    @Override
    public ComputerSystem createComputerSystem() {
        return new AixComputerSystem(this.lscfg);
    }

    @Override
    public GlobalMemory createMemory() {
        return new AixGlobalMemory(this.lscfg);
    }

    @Override
    public CentralProcessor createProcessor() {
        return new AixCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new AixSensors(this.lscfg);
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return AixHWDiskStore.getDisks(this.diskStats);
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean bl2) {
        return AixNetworkIF.getNetworks(bl2);
    }
}

