/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.PatternStep;

public class HasSuffixPatternStep
implements PatternStep {
    private final String suffix;
    private final boolean caseSensitive;
    private final int suffixLength;
    private final int prefixLength;

    public HasSuffixPatternStep(String string, boolean bl2) {
        this(string, bl2, 0);
    }

    HasSuffixPatternStep(String string, boolean bl2, int n2) {
        this.suffix = string;
        this.suffixLength = string.length();
        this.caseSensitive = bl2;
        this.prefixLength = n2;
    }

    public String toString() {
        return "{suffix: " + this.suffix + "}";
    }

    @Override
    public boolean matches(String string) {
        return this.isLongEnough(string) && string.regionMatches(!this.caseSensitive, string.length() - this.suffixLength, this.suffix, 0, this.suffixLength);
    }

    private boolean isLongEnough(String string) {
        return this.prefixLength + this.suffixLength <= string.length();
    }
}

