/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Set;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockCommunicator.class);
    private final DatagramSocket socket;
    private final InetAddressProvider inetAddressProvider;
    private volatile boolean stopped;

    public FileLockCommunicator(InetAddressProvider inetAddressProvider) {
        this.inetAddressProvider = inetAddressProvider;
        try {
            this.socket = new DatagramSocket(0, inetAddressProvider.getWildcardBindingAddress());
        }
        catch (SocketException socketException) {
            throw UncheckedException.throwAsUncheckedException(socketException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pingOwner(int n2, long l2, String string) {
        boolean bl2 = false;
        try {
            byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.UNLOCK_REQUEST);
            for (InetAddress inetAddress : this.inetAddressProvider.getCommunicationAddresses()) {
                try {
                    this.socket.send(new DatagramPacket(byArray, byArray.length, inetAddress, n2));
                    bl2 = true;
                }
                catch (IOException iOException) {
                    String string2 = iOException.getMessage();
                    if (string2 == null || !string2.startsWith("Operation not permitted") && !string2.startsWith("Network is unreachable") && !string2.startsWith("Cannot assign requested address")) throw iOException;
                    LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{string, l2, n2, inetAddress});
                    continue;
                    return bl2;
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Failed to ping owner of lock for %s (lock id: %s, port: %s)", string, l2, n2), iOException);
        }
    }

    public DatagramPacket receive() throws GracefullyStoppedException {
        try {
            byte[] byArray = new byte[10];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.socket.receive(datagramPacket);
            return datagramPacket;
        }
        catch (IOException iOException) {
            if (!this.stopped) {
                throw new RuntimeException(iOException);
            }
            throw new GracefullyStoppedException();
        }
    }

    public FileLockPacketPayload decode(DatagramPacket datagramPacket) {
        try {
            return FileLockPacketPayload.decode(datagramPacket.getData(), datagramPacket.getLength());
        }
        catch (IOException iOException) {
            if (!this.stopped) {
                throw new RuntimeException(iOException);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmUnlockRequest(SocketAddress socketAddress, long l2) {
        try {
            byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.UNLOCK_REQUEST_CONFIRMATION);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramPacket.setSocketAddress(socketAddress);
            this.socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            if (!this.stopped) {
                throw new RuntimeException(iOException);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmLockRelease(Set<SocketAddress> set, long l2) {
        byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.LOCK_RELEASE_CONFIRMATION);
        for (SocketAddress socketAddress : set) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramPacket.setSocketAddress(socketAddress);
            LOGGER.debug("Confirming lock release to Gradle process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
            try {
                this.socket.send(datagramPacket);
            }
            catch (IOException iOException) {
                if (this.stopped) continue;
                LOGGER.debug("Failed to confirm lock release to Gradle process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

