/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ReaderSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;

public final class BranchingReaderSource
extends ReaderSource {
    TextBuffer mBranchBuffer = null;
    int mBranchStartOffset = 0;
    boolean mConvertLFs = false;
    boolean mGotCR = false;

    public BranchingReaderSource(ReaderConfig readerConfig, String string, SystemId systemId, Reader reader, boolean bl2) {
        super(readerConfig, null, null, string, systemId, reader, bl2);
    }

    @Override
    public int readInto(WstxInputData wstxInputData) throws IOException, XMLStreamException {
        if (this.mBranchBuffer != null) {
            if (this.mInputLast > this.mBranchStartOffset) {
                this.appendBranched(this.mBranchStartOffset, this.mInputLast);
            }
            this.mBranchStartOffset = 0;
        }
        return super.readInto(wstxInputData);
    }

    @Override
    public boolean readMore(WstxInputData wstxInputData, int n2) throws IOException, XMLStreamException {
        int n3;
        int n4;
        if (this.mBranchBuffer != null && (n4 = this.mInputLast - (n3 = wstxInputData.mInputPtr)) > 0) {
            if (n3 > this.mBranchStartOffset) {
                this.appendBranched(this.mBranchStartOffset, n3);
            }
            this.mBranchStartOffset = 0;
        }
        return super.readMore(wstxInputData, n2);
    }

    public void startBranch(TextBuffer textBuffer, int n2, boolean bl2) {
        this.mBranchBuffer = textBuffer;
        this.mBranchStartOffset = n2;
        this.mConvertLFs = bl2;
        this.mGotCR = false;
    }

    public void endBranch(int n2) {
        if (this.mBranchBuffer != null) {
            if (n2 > this.mBranchStartOffset) {
                this.appendBranched(this.mBranchStartOffset, n2);
            }
            this.mBranchBuffer = null;
        }
    }

    private void appendBranched(int n2, int n3) {
        if (this.mConvertLFs) {
            char[] cArray = this.mBuffer;
            char[] cArray2 = this.mBranchBuffer.getCurrentSegment();
            int n4 = this.mBranchBuffer.getCurrentSegmentSize();
            if (this.mGotCR && cArray[n2] == '\n') {
                ++n2;
            }
            while (n2 < n3) {
                int n5;
                if ((n5 = cArray[n2++]) == 13) {
                    if (n2 < n3) {
                        if (cArray[n2] == '\n') {
                            ++n2;
                        }
                    } else {
                        this.mGotCR = true;
                    }
                    n5 = 10;
                }
                cArray2[n4++] = n5;
                if (n4 < cArray2.length) continue;
                cArray2 = this.mBranchBuffer.finishCurrentSegment();
                n4 = 0;
            }
            this.mBranchBuffer.setCurrentLength(n4);
        } else {
            this.mBranchBuffer.append(this.mBuffer, n2, n3 - n2);
        }
    }
}

