/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public class UUIDSerializer
extends StdScalarSerializer<UUID>
implements ContextualSerializer {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    protected final Boolean _asBinary;

    public UUIDSerializer() {
        this((Boolean)null);
    }

    protected UUIDSerializer(Boolean bl2) {
        super(UUID.class);
        this._asBinary = bl2;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, UUID uUID) {
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        Boolean bl2 = null;
        if (value != null) {
            JsonFormat.Shape shape = value.getShape();
            if (shape == JsonFormat.Shape.BINARY) {
                bl2 = true;
            } else if (shape == JsonFormat.Shape.STRING) {
                bl2 = false;
            }
        }
        if (!Objects.equals(bl2, this._asBinary)) {
            return new UUIDSerializer(bl2);
        }
        return this;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._writeAsBinary(jsonGenerator)) {
            jsonGenerator.writeBinary(UUIDSerializer._asBytes(uUID));
            return;
        }
        char[] cArray = new char[36];
        long l2 = uUID.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(l2 >> 32), cArray, 0);
        cArray[8] = 45;
        int n2 = (int)l2;
        UUIDSerializer._appendShort(n2 >>> 16, cArray, 9);
        cArray[13] = 45;
        UUIDSerializer._appendShort(n2, cArray, 14);
        cArray[18] = 45;
        long l3 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(l3 >>> 48), cArray, 19);
        cArray[23] = 45;
        UUIDSerializer._appendShort((int)(l3 >>> 32), cArray, 24);
        UUIDSerializer._appendInt((int)l3, cArray, 28);
        jsonGenerator.writeString(cArray, 0, 36);
    }

    protected boolean _writeAsBinary(JsonGenerator jsonGenerator) {
        if (this._asBinary != null) {
            return this._asBinary;
        }
        return !(jsonGenerator instanceof TokenBuffer) && jsonGenerator.canWriteBinaryNatively();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.UUID);
    }

    private static void _appendInt(int n2, char[] cArray, int n3) {
        UUIDSerializer._appendShort(n2 >> 16, cArray, n3);
        UUIDSerializer._appendShort(n2, cArray, n3 + 4);
    }

    private static void _appendShort(int n2, char[] cArray, int n3) {
        cArray[n3] = HEX_CHARS[n2 >> 12 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 >> 8 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 >> 4 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 & 0xF];
    }

    private static final byte[] _asBytes(UUID uUID) {
        byte[] byArray = new byte[16];
        long l2 = uUID.getMostSignificantBits();
        long l3 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendInt((int)(l2 >> 32), byArray, 0);
        UUIDSerializer._appendInt((int)l2, byArray, 4);
        UUIDSerializer._appendInt((int)(l3 >> 32), byArray, 8);
        UUIDSerializer._appendInt((int)l3, byArray, 12);
        return byArray;
    }

    private static final void _appendInt(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 24);
        byArray[++n3] = (byte)(n2 >> 16);
        byArray[++n3] = (byte)(n2 >> 8);
        byArray[++n3] = (byte)n2;
    }
}

