/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

public class StaxUtil {
    public static <T> T throwAsParseException(XMLStreamException xMLStreamException, JsonParser jsonParser) throws IOException {
        Throwable throwable = StaxUtil._unwrap(xMLStreamException);
        throw new JsonParseException(jsonParser, StaxUtil._message(throwable, xMLStreamException), throwable);
    }

    public static <T> T throwAsGenerationException(XMLStreamException xMLStreamException, JsonGenerator jsonGenerator) throws IOException {
        Throwable throwable = StaxUtil._unwrap(xMLStreamException);
        throw new JsonGenerationException(StaxUtil._message(throwable, xMLStreamException), throwable, jsonGenerator);
    }

    private static Throwable _unwrap(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    private static String _message(Throwable throwable, Throwable throwable2) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable2.getMessage();
        }
        return string;
    }

    public static String sanitizeXmlTypeName(String string) {
        StringBuilder stringBuilder;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        if (string.endsWith("[]")) {
            do {
                string = string.substring(0, string.length() - 2);
                ++n2;
            } while (string.endsWith("[]"));
            stringBuilder = new StringBuilder(string);
            if (string.endsWith("s")) {
                stringBuilder.append("es");
            } else {
                stringBuilder.append('s');
            }
        } else {
            stringBuilder = new StringBuilder(string);
        }
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == '-') continue;
            ++n2;
            if (c2 == '$') {
                stringBuilder.setCharAt(i2, '.');
                continue;
            }
            stringBuilder.setCharAt(i2, '_');
        }
        if (n2 == 0) {
            return string;
        }
        return stringBuilder.toString();
    }

    public static com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant toStax2Base64Variant(Base64Variant base64Variant) {
        return Base64Mapper.instance.map(base64Variant);
    }

    public static XMLInputFactory defaultInputFactory(ClassLoader classLoader) {
        try {
            return XMLInputFactory.newFactory(XMLInputFactory.class.getName(), classLoader);
        }
        catch (NoSuchMethodError | FactoryConfigurationError error) {
            return XMLInputFactory.newInstance();
        }
    }

    public static XMLOutputFactory defaultOutputFactory(ClassLoader classLoader) {
        try {
            return XMLOutputFactory.newFactory(XMLOutputFactory.class.getName(), classLoader);
        }
        catch (NoSuchMethodError | FactoryConfigurationError error) {
            return XMLOutputFactory.newInstance();
        }
    }

    private static class Base64Mapper {
        public static final Base64Mapper instance = new Base64Mapper();
        private final Map<String, com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant> j2stax2 = new HashMap<String, com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant>();

        private Base64Mapper() {
            this.j2stax2.put(com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants.MIME.getName(), Base64Variants.MIME);
            this.j2stax2.put(com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants.MIME_NO_LINEFEEDS.getName(), Base64Variants.MIME_NO_LINEFEEDS);
            this.j2stax2.put(com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants.MODIFIED_FOR_URL.getName(), Base64Variants.MODIFIED_FOR_URL);
            this.j2stax2.put(com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants.PEM.getName(), Base64Variants.PEM);
        }

        public com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant map(Base64Variant base64Variant) {
            com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant base64Variant2 = this.j2stax2.get(base64Variant.getName());
            if (base64Variant2 == null) {
                base64Variant2 = Base64Variants.getDefaultVariant();
            }
            return base64Variant2;
        }
    }
}

