/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputListRecycler(){

        @Override
        public void recycle(CodecOutputList codecOutputList) {
        }
    };
    private static final FastThreadLocal<CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new FastThreadLocal<CodecOutputLists>(){

        @Override
        protected CodecOutputLists initialValue() throws Exception {
            return new CodecOutputLists(16);
        }
    };
    private final CodecOutputListRecycler recycler;
    private int size;
    private int maxSeenSize;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return CODEC_OUTPUT_LISTS_POOL.get().getOrCreate();
    }

    private CodecOutputList(CodecOutputListRecycler codecOutputListRecycler, int n2) {
        this.recycler = codecOutputListRecycler;
        this.array = new Object[n2];
    }

    @Override
    public Object get(int n2) {
        this.checkIndex(n2);
        return this.array[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            this.insert(this.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            this.insert(this.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public Object set(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        Object object2 = this.array[n2];
        this.insert(n2, object);
        return object2;
    }

    @Override
    public void add(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n2 != this.size) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        }
        this.insert(n2, object);
        ++this.size;
    }

    @Override
    public Object remove(int n2) {
        this.checkIndex(n2);
        Object object = this.array[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, n3);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public void clear() {
        this.maxSeenSize = Math.max(this.maxSeenSize, this.size);
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    void recycle() {
        int n2 = Math.max(this.maxSeenSize, this.size);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.array[i2] = null;
        }
        this.size = 0;
        this.maxSeenSize = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    Object getUnsafe(int n2) {
        return this.array[n2];
    }

    private void checkIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("expected: index < (" + this.size + "),but actual is (" + this.size + ")");
        }
    }

    private void insert(int n2, Object object) {
        this.array[n2] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n2 = this.array.length << 1;
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    private static final class CodecOutputLists
    implements CodecOutputListRecycler {
        private final CodecOutputList[] elements;
        private final int mask;
        private int currentIdx;
        private int count;

        CodecOutputLists(int n2) {
            this.elements = new CodecOutputList[MathUtil.safeFindNextPositivePowerOfTwo(n2)];
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                this.elements[i2] = new CodecOutputList(this, 16);
            }
            this.count = this.elements.length;
            this.currentIdx = this.elements.length;
            this.mask = this.elements.length - 1;
        }

        public CodecOutputList getOrCreate() {
            if (this.count == 0) {
                return new CodecOutputList(NOOP_RECYCLER, 4);
            }
            --this.count;
            int n2 = this.currentIdx - 1 & this.mask;
            CodecOutputList codecOutputList = this.elements[n2];
            this.currentIdx = n2;
            return codecOutputList;
        }

        @Override
        public void recycle(CodecOutputList codecOutputList) {
            int n2 = this.currentIdx;
            this.elements[n2] = codecOutputList;
            this.currentIdx = n2 + 1 & this.mask;
            ++this.count;
            assert (this.count <= this.elements.length);
        }
    }

    private static interface CodecOutputListRecycler {
        public void recycle(CodecOutputList var1);
    }
}

