/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.JdkAlpnSslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

final class BouncyCastleAlpnSslUtils {
    private static final InternalLogger logger;
    private static final Method SET_PARAMETERS;
    private static final Method GET_PARAMETERS;
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Class BC_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method BC_APPLICATION_PROTOCOL_SELECTOR_SELECT;

    private BouncyCastleAlpnSslUtils() {
    }

    static String getApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setApplicationProtocols(SSLEngine sSLEngine, List<String> list) {
        String[] stringArray = list.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            Object object = GET_PARAMETERS.invoke((Object)sSLEngine, new Object[0]);
            SET_APPLICATION_PROTOCOLS.invoke(object, new Object[]{stringArray});
            SET_PARAMETERS.invoke((Object)sSLEngine, object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        if (PlatformDependent.javaVersion() >= 9) {
            JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, list);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sSLEngine, final BiFunction<SSLEngine, List<String>, String> biFunction) {
        try {
            Object object = Proxy.newProxyInstance(BouncyCastleAlpnSslUtils.class.getClassLoader(), new Class[]{BC_APPLICATION_PROTOCOL_SELECTOR}, new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    if (method.getName().equals("select")) {
                        try {
                            return biFunction.apply((SSLEngine)objectArray[0], (List)objectArray[1]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new RuntimeException("BCApplicationProtocolSelector select method parameter of invalid type.", classCastException);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Method '%s' not supported.", method.getName()));
                }
            });
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine sSLEngine) {
        try {
            final Object object = GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, new Object[0]);
            return new BiFunction<SSLEngine, List<String>, String>(){

                @Override
                public String apply(SSLEngine sSLEngine, List<String> list) {
                    try {
                        return (String)BC_APPLICATION_PROTOCOL_SELECTOR_SELECT.invoke(object, sSLEngine, list);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Could not call getHandshakeApplicationProtocolSelector", exception);
                    }
                }
            };
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Method method4;
        Method method5;
        Method method6;
        Method method7;
        Method method8;
        Class<?> clazz;
        logger = InternalLoggerFactory.getInstance(BouncyCastleAlpnSslUtils.class);
        try {
            Class<?> clazz2;
            final Class<?> clazz3 = clazz2 = Class.forName("org.bouncycastle.jsse.BCSSLEngine");
            final Class<?> clazz4 = clazz = Class.forName("org.bouncycastle.jsse.BCApplicationProtocolSelector");
            method8 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz4.getMethod("select", Object.class, List.class);
                }
            });
            SSLContext sSLContext = SslUtils.getSSLContext("BCJSSE");
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            method7 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getParameters", new Class[0]);
                }
            });
            Object object = method7.invoke((Object)sSLEngine, new Object[0]);
            final Class<?> clazz5 = object.getClass();
            method6 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("setParameters", clazz5);
                }
            });
            method6.invoke((Object)sSLEngine, object);
            method5 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz5.getMethod("setApplicationProtocols", String[].class);
                }
            });
            method5.invoke(object, new Object[]{EmptyArrays.EMPTY_STRINGS});
            method4 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            method4.invoke((Object)sSLEngine, new Object[0]);
            method3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getHandshakeApplicationProtocol", new Class[0]);
                }
            });
            method3.invoke((Object)sSLEngine, new Object[0]);
            method2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("setBCHandshakeApplicationProtocolSelector", clazz4);
                }
            });
            method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getBCHandshakeApplicationProtocolSelector", new Class[0]);
                }
            });
            method.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (Throwable throwable) {
            logger.error("Unable to initialize BouncyCastleAlpnSslUtils.", throwable);
            method6 = null;
            method7 = null;
            method5 = null;
            method4 = null;
            method3 = null;
            method2 = null;
            method = null;
            method8 = null;
            clazz = null;
        }
        SET_PARAMETERS = method6;
        GET_PARAMETERS = method7;
        SET_APPLICATION_PROTOCOLS = method5;
        GET_APPLICATION_PROTOCOL = method4;
        GET_HANDSHAKE_APPLICATION_PROTOCOL = method3;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method2;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method;
        BC_APPLICATION_PROTOCOL_SELECTOR_SELECT = method8;
        BC_APPLICATION_PROTOCOL_SELECTOR = clazz;
    }
}

