/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.PromiseTask;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.ScheduledFuture;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.DefaultPriorityQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PriorityQueueNode;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V>,
PriorityQueueNode {
    private long id;
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l2;
        this.periodNanos = 0L;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l2, long l3) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l2;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l3);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2, long l3) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l2;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l3);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l2;
        this.periodNanos = 0L;
    }

    private static long validatePeriod(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        return l2;
    }

    ScheduledFutureTask<V> setId(long l2) {
        if (this.id == 0L) {
            this.id = l2;
        }
        return this;
    }

    @Override
    protected EventExecutor executor() {
        return super.executor();
    }

    public long deadlineNanos() {
        return this.deadlineNanos;
    }

    void setConsumed() {
        if (this.periodNanos == 0L) {
            assert (this.scheduledExecutor().getCurrentTimeNanos() >= this.deadlineNanos);
            this.deadlineNanos = 0L;
        }
    }

    public long delayNanos() {
        if (this.deadlineNanos == 0L) {
            return 0L;
        }
        return this.delayNanos(this.scheduledExecutor().getCurrentTimeNanos());
    }

    static long deadlineToDelayNanos(long l2, long l3) {
        return l3 == 0L ? 0L : Math.max(0L, l3 - l2);
    }

    public long delayNanos(long l2) {
        return ScheduledFutureTask.deadlineToDelayNanos(l2, this.deadlineNanos);
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
        long l2 = this.deadlineNanos() - scheduledFutureTask.deadlineNanos();
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        if (this.id < scheduledFutureTask.id) {
            return -1;
        }
        assert (this.id != scheduledFutureTask.id);
        return 1;
    }

    @Override
    public void run() {
        assert (this.executor().inEventLoop());
        try {
            if (this.delayNanos() > 0L) {
                if (this.isCancelled()) {
                    this.scheduledExecutor().scheduledTaskQueue().removeTyped(this);
                } else {
                    this.scheduledExecutor().scheduleFromEventLoop(this);
                }
                return;
            }
            if (this.periodNanos == 0L) {
                if (this.setUncancellableInternal()) {
                    Object v2 = this.runTask();
                    this.setSuccessInternal(v2);
                }
            } else if (!this.isCancelled()) {
                this.runTask();
                if (!this.executor().isShutdown()) {
                    this.deadlineNanos = this.periodNanos > 0L ? (this.deadlineNanos += this.periodNanos) : this.scheduledExecutor().getCurrentTimeNanos() - this.periodNanos;
                    if (!this.isCancelled()) {
                        this.scheduledExecutor().scheduledTaskQueue().add(this);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    private AbstractScheduledEventExecutor scheduledExecutor() {
        return (AbstractScheduledEventExecutor)this.executor();
    }

    @Override
    public boolean cancel(boolean bl2) {
        boolean bl3 = super.cancel(bl2);
        if (bl3) {
            this.scheduledExecutor().removeScheduled(this);
        }
        return bl3;
    }

    boolean cancelWithoutRemove(boolean bl2) {
        return super.cancel(bl2);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }

    @Override
    public int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
        return this.queueIndex;
    }

    @Override
    public void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n2) {
        this.queueIndex = n2;
    }
}

