/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class BooleanComparators {
    public static final BooleanComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final BooleanComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static BooleanComparator oppositeComparator(BooleanComparator booleanComparator) {
        if (booleanComparator instanceof OppositeComparator) {
            return ((OppositeComparator)booleanComparator).comparator;
        }
        return new OppositeComparator(booleanComparator);
    }

    public static BooleanComparator asBooleanComparator(final Comparator<? super Boolean> comparator) {
        if (comparator == null || comparator instanceof BooleanComparator) {
            return (BooleanComparator)comparator;
        }
        return new BooleanComparator(){

            @Override
            public int compare(boolean bl2, boolean bl3) {
                return comparator.compare(bl2, bl3);
            }

            @Override
            public int compare(Boolean bl2, Boolean bl3) {
                return comparator.compare(bl2, bl3);
            }
        };
    }

    protected static class OppositeComparator
    implements BooleanComparator,
    Serializable {
        final BooleanComparator comparator;

        protected OppositeComparator(BooleanComparator booleanComparator) {
            this.comparator = booleanComparator;
        }

        @Override
        public final int compare(boolean bl2, boolean bl3) {
            return this.comparator.compare(bl3, bl2);
        }

        @Override
        public final BooleanComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements BooleanComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(boolean bl2, boolean bl3) {
            return Boolean.compare(bl2, bl3);
        }

        @Override
        public BooleanComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements BooleanComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(boolean bl2, boolean bl3) {
            return -Boolean.compare(bl2, bl3);
        }

        @Override
        public BooleanComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

