/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class FloatComparators {
    public static final FloatComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final FloatComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static FloatComparator oppositeComparator(FloatComparator floatComparator) {
        if (floatComparator instanceof OppositeComparator) {
            return ((OppositeComparator)floatComparator).comparator;
        }
        return new OppositeComparator(floatComparator);
    }

    public static FloatComparator asFloatComparator(final Comparator<? super Float> comparator) {
        if (comparator == null || comparator instanceof FloatComparator) {
            return (FloatComparator)comparator;
        }
        return new FloatComparator(){

            @Override
            public int compare(float f2, float f3) {
                return comparator.compare(Float.valueOf(f2), Float.valueOf(f3));
            }

            @Override
            public int compare(Float f2, Float f3) {
                return comparator.compare(f2, f3);
            }
        };
    }

    protected static class OppositeComparator
    implements FloatComparator,
    Serializable {
        final FloatComparator comparator;

        protected OppositeComparator(FloatComparator floatComparator) {
            this.comparator = floatComparator;
        }

        @Override
        public final int compare(float f2, float f3) {
            return this.comparator.compare(f3, f2);
        }

        @Override
        public final FloatComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements FloatComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(float f2, float f3) {
            return Float.compare(f2, f3);
        }

        @Override
        public FloatComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements FloatComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(float f2, float f3) {
            return -Float.compare(f2, f3);
        }

        @Override
        public FloatComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

