/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntConsumer;

public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected AbstractIntList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(int n2) {
        this.add(this.size(), n2);
        return true;
    }

    @Override
    public int removeInt(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int set(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Integer> collection) {
        if (collection instanceof IntCollection) {
            return this.addAll(n2, (IntCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Integer> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (int)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public IntListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new IntIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final int get(int n2) {
                return AbstractIntList.this.getInt(n2);
            }

            @Override
            protected final void add(int n2, int n3) {
                AbstractIntList.this.add(n2, n3);
            }

            @Override
            protected final void set(int n2, int n3) {
                AbstractIntList.this.set(n2, n3);
            }

            @Override
            protected final void remove(int n2) {
                AbstractIntList.this.removeInt(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractIntList.this.size();
            }
        };
    }

    @Override
    public boolean contains(int n2) {
        return this.indexOf(n2) >= 0;
    }

    @Override
    public int indexOf(int n2) {
        IntListIterator intListIterator = this.listIterator();
        while (intListIterator.hasNext()) {
            int n3 = intListIterator.nextInt();
            if (n2 != n3) continue;
            return intListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n2) {
        IntListIterator intListIterator = this.listIterator(this.size());
        while (intListIterator.hasPrevious()) {
            int n3 = intListIterator.previousInt();
            if (n2 != n3) continue;
            return intListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public IntList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new IntRandomAccessSubList(this, n2, n3) : new IntSubList(this, n2, n3);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                intConsumer.accept(this.getInt(i2));
            }
        } else {
            IntList.super.forEach(intConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        IntListIterator intListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            intListIterator.nextInt();
            intListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                nArray[n3++] = this.getInt(n5++);
            }
        } else {
            IntListIterator intListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                nArray[n3++] = intListIterator.nextInt();
            }
        }
    }

    @Override
    public void setElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, nArray[i2 + n3]);
            }
        } else {
            IntListIterator intListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                intListIterator.nextInt();
                intListIterator.set(nArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        IntListIterator intListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            int n4 = intListIterator.nextInt();
            n2 = 31 * n2 + n4;
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof IntList) {
            IntListIterator intListIterator = this.listIterator();
            IntListIterator intListIterator2 = ((IntList)list).listIterator();
            while (n2-- != 0) {
                if (intListIterator.nextInt() == intListIterator2.nextInt()) continue;
                return false;
            }
            return true;
        }
        IntListIterator intListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(intListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Integer> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof IntList) {
            IntListIterator intListIterator = this.listIterator();
            IntListIterator intListIterator2 = ((IntList)list).listIterator();
            while (intListIterator.hasNext() && intListIterator2.hasNext()) {
                int n2;
                int n3 = intListIterator.nextInt();
                int n4 = Integer.compare(n3, n2 = intListIterator2.nextInt());
                if (n4 == 0) continue;
                return n4;
            }
            return intListIterator2.hasNext() ? -1 : (intListIterator.hasNext() ? 1 : 0);
        }
        IntListIterator intListIterator = this.listIterator();
        ListIterator<? extends Integer> listIterator = list.listIterator();
        while (intListIterator.hasNext() && listIterator.hasNext()) {
            int n5 = ((Comparable)intListIterator.next()).compareTo(listIterator.next());
            if (n5 == 0) continue;
            return n5;
        }
        return listIterator.hasNext() ? -1 : (intListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 == -1) {
            return false;
        }
        this.removeInt(n3);
        return true;
    }

    @Override
    public int[] toIntArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        int[] nArray = new int[n2];
        this.getElements(0, nArray, 0, n2);
        return nArray;
    }

    public boolean addAll(int n2, IntCollection intCollection) {
        this.ensureIndex(n2);
        IntIterator intIterator = intCollection.iterator();
        boolean bl2 = intIterator.hasNext();
        while (intIterator.hasNext()) {
            this.add(n2++, intIterator.nextInt());
        }
        return bl2;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        return this.addAll(this.size(), intCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntListIterator intListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            int n3 = intListIterator.nextInt();
            stringBuilder.append(String.valueOf(n3));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class IntRandomAccessSubList
    extends IntSubList
    implements RandomAccess {
        public IntRandomAccessSubList(IntList intList, int n2, int n3) {
            super(intList, n2, n3);
        }

        @Override
        public IntList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new IntRandomAccessSubList(this, n2, n3);
        }
    }

    public static class IntSubList
    extends AbstractIntList
    implements Serializable {
        protected final IntList l;
        protected final int from;
        protected int to;

        public IntSubList(IntList intList, int n2, int n3) {
            this.l = intList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(int n2) {
            this.l.add(this.to, n2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, int n3) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, n3);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Integer> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public int getInt(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getInt(this.from + n2);
        }

        @Override
        public int removeInt(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeInt(this.from + n2);
        }

        @Override
        public int set(int n2, int n3) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, n3);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, int[] nArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, nArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, int[] nArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, nArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public IntListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public IntSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public IntList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new IntSubList(this, n2, n3);
        }

        @Override
        public boolean rem(int n2) {
            int n3 = this.indexOf(n2);
            if (n3 == -1) {
                return false;
            }
            --this.to;
            this.l.removeInt(this.from + n3);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, IntCollection intCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, intCollection);
        }

        private final class RandomAccessIter
        extends IntIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final int get(int n2) {
                return IntSubList.this.l.getInt(IntSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, int n3) {
                IntSubList.this.add(n2, n3);
            }

            @Override
            protected final void set(int n2, int n3) {
                IntSubList.this.set(n2, n3);
            }

            @Override
            protected final void remove(int n2) {
                IntSubList.this.removeInt(n2);
            }

            @Override
            protected final int getMaxPos() {
                return IntSubList.this.to - IntSubList.this.from;
            }

            @Override
            public void add(int n2) {
                super.add(n2);
                assert (IntSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (IntSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements IntListIterator {
            private IntListIterator parent;

            ParentWrappingIter(IntListIterator intListIterator) {
                this.parent = intListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - IntSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - IntSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < IntSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= IntSubList.this.from;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextInt();
            }

            @Override
            public int previousInt() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousInt();
            }

            @Override
            public void add(int n2) {
                this.parent.add(n2);
            }

            @Override
            public void set(int n2) {
                this.parent.set(n2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends IntSpliterators.LateBindingSizeIndexBasedSpliterator {
        final IntList l;

        IndexBasedSpliterator(IntList intList, int n2) {
            super(n2);
            this.l = intList;
        }

        IndexBasedSpliterator(IntList intList, int n2, int n3) {
            super(n2, n3);
            this.l = intList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final int get(int n2) {
            return this.l.getInt(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

