/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class LongComparators {
    public static final LongComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final LongComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static LongComparator oppositeComparator(LongComparator longComparator) {
        if (longComparator instanceof OppositeComparator) {
            return ((OppositeComparator)longComparator).comparator;
        }
        return new OppositeComparator(longComparator);
    }

    public static LongComparator asLongComparator(final Comparator<? super Long> comparator) {
        if (comparator == null || comparator instanceof LongComparator) {
            return (LongComparator)comparator;
        }
        return new LongComparator(){

            @Override
            public int compare(long l2, long l3) {
                return comparator.compare(l2, l3);
            }

            @Override
            public int compare(Long l2, Long l3) {
                return comparator.compare(l2, l3);
            }
        };
    }

    protected static class OppositeComparator
    implements LongComparator,
    Serializable {
        final LongComparator comparator;

        protected OppositeComparator(LongComparator longComparator) {
            this.comparator = longComparator;
        }

        @Override
        public final int compare(long l2, long l3) {
            return this.comparator.compare(l3, l2);
        }

        @Override
        public final LongComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements LongComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(long l2, long l3) {
            return Long.compare(l2, l3);
        }

        @Override
        public LongComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements LongComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(long l2, long l3) {
            return -Long.compare(l2, l3);
        }

        @Override
        public LongComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

