/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.AbstractShortList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortSpliterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortUnaryOperator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public interface ShortList
extends ShortCollection,
Comparable<List<? extends Short>>,
List<Short> {
    @Override
    public ShortListIterator iterator();

    @Override
    default public ShortSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractShortList.IndexBasedSpliterator(this, 0);
        }
        return ShortSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public ShortListIterator listIterator();

    public ShortListIterator listIterator(int var1);

    public ShortList subList(int var1, int var2);

    public void getElements(int var1, short[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(short[] sArray) {
        this.setElements(0, sArray);
    }

    default public void setElements(int n2, short[] sArray) {
        this.setElements(n2, sArray, 0, sArray.length);
    }

    default public void setElements(int n2, short[] sArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        ShortArrays.ensureOffsetLength(sArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        ShortListIterator shortListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            shortListIterator.nextShort();
            shortListIterator.set(sArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(short var1);

    @Override
    public void add(int var1, short var2);

    @Override
    @Deprecated
    default public void add(int n2, Short s2) {
        this.add(n2, (short)s2);
    }

    @Override
    public short set(int var1, short var2);

    default public void replaceAll(ShortUnaryOperator shortUnaryOperator) {
        ShortListIterator shortListIterator = this.listIterator();
        while (shortListIterator.hasNext()) {
            shortListIterator.set(shortUnaryOperator.apply(shortListIterator.nextShort()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Short> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof ShortUnaryOperator ? (ShortUnaryOperator)unaryOperator : unaryOperator::apply);
    }

    public short getShort(int var1);

    public int indexOf(short var1);

    public int lastIndexOf(short var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return ShortCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Short get(int n2) {
        return this.getShort(n2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf((Short)object);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf((Short)object);
    }

    @Override
    @Deprecated
    default public boolean add(Short s2) {
        return this.add((short)s2);
    }

    public short removeShort(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return ShortCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Short remove(int n2) {
        return this.removeShort(n2);
    }

    @Override
    @Deprecated
    default public Short set(int n2, Short s2) {
        return this.set(n2, (short)s2);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Short> comparator) {
        this.sort(ShortComparators.asShortComparator(comparator));
    }

    default public void sort(ShortComparator shortComparator) {
        if (shortComparator == null) {
            this.unstableSort(shortComparator);
        } else {
            short[] sArray = this.toShortArray();
            ShortArrays.stableSort(sArray, shortComparator);
            this.setElements(sArray);
        }
    }

    default public void unstableSort(ShortComparator shortComparator) {
        short[] sArray = this.toShortArray();
        if (shortComparator == null) {
            ShortArrays.unstableSort(sArray);
        } else {
            ShortArrays.unstableSort(sArray, shortComparator);
        }
        this.setElements(sArray);
    }
}

