/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.AbstractShortSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class ShortSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static ShortSpliterator wrap(short[] sArray, int n2, int n3, int n4) {
        ShortArrays.ensureOffsetLength(sArray, n2, n3);
        return new ArraySpliterator(sArray, n2, n3, n4);
    }

    public static ShortSpliterator wrapPreSorted(short[] sArray, int n2, int n3, int n4, ShortComparator shortComparator) {
        ShortArrays.ensureOffsetLength(sArray, n2, n3);
        return new ArraySpliteratorWithComparator(sArray, n2, n3, n4, shortComparator);
    }

    public static ShortSpliterator asSpliterator(ShortIterator shortIterator, long l2, int n2) {
        return new SpliteratorFromIterator(shortIterator, l2, n2);
    }

    public static ShortSpliterator asSpliteratorFromSorted(ShortIterator shortIterator, long l2, int n2, ShortComparator shortComparator) {
        return new SpliteratorFromIteratorWithComparator(shortIterator, l2, n2, shortComparator);
    }

    public static ShortSpliterator asSpliteratorUnknownSize(ShortIterator shortIterator, int n2) {
        return new SpliteratorFromIterator(shortIterator, n2);
    }

    private static class ArraySpliterator
    implements ShortSpliterator {
        final short[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(short[] sArray, int n2, int n3, int n4) {
            this.array = sArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(ShortConsumer shortConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(shortConsumer);
            shortConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public ShortSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
            Objects.requireNonNull(shortConsumer);
            short[] sArray = this.array;
            while (this.curr < this.length) {
                shortConsumer.accept(sArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final ShortComparator comparator;

        public ArraySpliteratorWithComparator(short[] sArray, int n2, int n3, int n4, ShortComparator shortComparator) {
            super(sArray, n2, n3, n4 | 0x14);
            this.comparator = shortComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public ShortComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements ShortSpliterator {
        private final ShortIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private ShortSpliterator delegate = null;

        SpliteratorFromIterator(ShortIterator shortIterator, int n2) {
            this.iter = shortIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(ShortIterator shortIterator, long l2, int n2) {
            this.iter = shortIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(ShortConsumer shortConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(shortConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            shortConsumer.accept(this.iter.nextShort());
            return true;
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(shortConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(shortConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ShortSpliterator makeForSplit(short[] sArray, int n2) {
            return ShortSpliterators.wrap(sArray, 0, n2, this.characteristics);
        }

        @Override
        public ShortSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            short[] sArray = new short[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                sArray[n3++] = this.iter.nextShort();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                sArray = Arrays.copyOf(sArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    sArray[n3++] = this.iter.nextShort();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            ShortSpliterator shortSpliterator = this.makeForSplit(sArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = shortSpliterator;
                return shortSpliterator.trySplit();
            }
            return shortSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final ShortComparator comparator;

        SpliteratorFromIteratorWithComparator(ShortIterator shortIterator, long l2, int n2, ShortComparator shortComparator) {
            super(shortIterator, l2, n2 | 0x14);
            this.comparator = shortComparator;
        }

        @Override
        public ShortComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected ShortSpliterator makeForSplit(short[] sArray, int n2) {
            return ShortSpliterators.wrapPreSorted(sArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements ShortSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(ShortConsumer shortConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Short> consumer) {
            return false;
        }

        @Override
        public ShortSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Short> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public ShortSpliterator trySplit() {
            ShortSpliterator shortSpliterator = super.trySplit();
            if (!this.maxPosFixed && shortSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return shortSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractShortSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract short get(int var1);

        protected abstract int getMaxPos();

        protected abstract ShortSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(ShortConsumer shortConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            shortConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                shortConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public ShortSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            ShortSpliterator shortSpliterator = this.makeForSplit(n4, n3);
            if (shortSpliterator != null) {
                this.pos = n3;
            }
            return shortSpliterator;
        }
    }
}

