/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel;

import com.gradle.maven.extension.internal.dep.org.springframework.core.SpringProperties;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelCompilerMode;

public class SpelParserConfiguration {
    private static final SpelCompilerMode defaultCompilerMode;
    private final SpelCompilerMode compilerMode;
    private final ClassLoader compilerClassLoader;
    private final boolean autoGrowNullReferences;
    private final boolean autoGrowCollections;
    private final int maximumAutoGrowSize;
    private final int maximumExpressionLength;

    public SpelParserConfiguration() {
        this(null, null, false, false, Integer.MAX_VALUE);
    }

    public SpelParserConfiguration(SpelCompilerMode spelCompilerMode, ClassLoader classLoader, boolean bl2, boolean bl3, int n2) {
        this(spelCompilerMode, classLoader, bl2, bl3, n2, 10000);
    }

    public SpelParserConfiguration(SpelCompilerMode spelCompilerMode, ClassLoader classLoader, boolean bl2, boolean bl3, int n2, int n3) {
        this.compilerMode = spelCompilerMode != null ? spelCompilerMode : defaultCompilerMode;
        this.compilerClassLoader = classLoader;
        this.autoGrowNullReferences = bl2;
        this.autoGrowCollections = bl3;
        this.maximumAutoGrowSize = n2;
        this.maximumExpressionLength = n3;
    }

    public SpelCompilerMode getCompilerMode() {
        return this.compilerMode;
    }

    public ClassLoader getCompilerClassLoader() {
        return this.compilerClassLoader;
    }

    public boolean isAutoGrowNullReferences() {
        return this.autoGrowNullReferences;
    }

    public boolean isAutoGrowCollections() {
        return this.autoGrowCollections;
    }

    public int getMaximumAutoGrowSize() {
        return this.maximumAutoGrowSize;
    }

    public int getMaximumExpressionLength() {
        return this.maximumExpressionLength;
    }

    static {
        String string = SpringProperties.getProperty("spring.expression.compiler.mode");
        defaultCompilerMode = string != null ? SpelCompilerMode.valueOf(string.toUpperCase()) : SpelCompilerMode.OFF;
    }
}

