/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Type;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeCode;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.lang.reflect.Array;

public class TypeReference
extends SpelNodeImpl {
    private final int dimensions;
    private transient Class<?> type;

    public TypeReference(int n2, int n3, SpelNodeImpl spelNodeImpl, int n4) {
        super(n2, n3, spelNodeImpl);
        this.dimensions = n4;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        Object object;
        String string = (String)this.children[0].getValueInternal(expressionState).getValue();
        Assert.state(string != null, "No type name");
        if (!string.contains(".") && Character.isLowerCase(string.charAt(0)) && (object = TypeCode.valueOf(string.toUpperCase())) != TypeCode.OBJECT) {
            Class<?> clazz = this.makeArrayIfNecessary(((TypeCode)((Object)object)).getType());
            this.exitTypeDescriptor = "Ljava/lang/Class";
            this.type = clazz;
            return new TypedValue(clazz);
        }
        object = expressionState.findType(string);
        object = this.makeArrayIfNecessary((Class<?>)object);
        this.exitTypeDescriptor = "Ljava/lang/Class";
        this.type = object;
        return new TypedValue(object);
    }

    private Class<?> makeArrayIfNecessary(Class<?> clazz) {
        if (this.dimensions != 0) {
            for (int i2 = 0; i2 < this.dimensions; ++i2) {
                Object object = Array.newInstance(clazz, 0);
                clazz = object.getClass();
            }
        }
        return clazz;
    }

    @Override
    public String toStringAST() {
        StringBuilder stringBuilder = new StringBuilder("T(");
        stringBuilder.append(this.getChild(0).toStringAST());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            stringBuilder.append("[]");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        Assert.state(this.type != null, "No type available");
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Byte.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Character.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Double.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Float.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Integer.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Long.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Short.TYPE) {
                methodVisitor.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            }
        } else {
            methodVisitor.visitLdcInsn(Type.getType(this.type));
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

