/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class ClassUtils {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(9);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(64);
    private static final Set<Class<?>> javaLanguageInterfaces;
    private static final Map<Method, Method> interfaceMethodCache;

    private static void registerCommonClasses(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classLoader == null && (classLoader = ClassUtils.class.getClassLoader()) == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classLoader;
    }

    public static Class<?> forName(String string, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull((Object)string, "Name must not be null");
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz == null) {
            clazz = commonClassCache.get(string);
        }
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith("[]")) {
            String string2 = string.substring(0, string.length() - "[]".length());
            Class<?> clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        if (string.startsWith("[L") && string.endsWith(";")) {
            String string3 = string.substring("[L".length(), string.length() - 1);
            Class<?> clazz3 = ClassUtils.forName(string3, classLoader);
            return Array.newInstance(clazz3, 0).getClass();
        }
        if (string.startsWith("[")) {
            String string4 = string.substring("[".length());
            Class<?> clazz4 = ClassUtils.forName(string4, classLoader);
            return Array.newInstance(clazz4, 0).getClass();
        }
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(string, false, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                String string5 = string.substring(0, n2) + '$' + string.substring(n2 + 1);
                try {
                    return Class.forName(string5, false, classLoader2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    public static boolean isPresent(String string, ClassLoader classLoader) {
        try {
            ClassUtils.forName(string, classLoader);
            return true;
        }
        catch (IllegalAccessError illegalAccessError) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + string + "]: " + illegalAccessError.getMessage(), illegalAccessError);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> resolvePrimitiveClassName(String string) {
        Class<?> clazz = null;
        if (string != null && string.length() <= 7) {
            clazz = primitiveTypeNameMap.get(string);
        }
        return clazz;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2) {
        Assert.notNull(clazz, "Left-hand side type must not be null");
        Assert.notNull(clazz2, "Right-hand side type must not be null");
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            Class<?> clazz3 = primitiveWrapperTypeMap.get(clazz2);
            return clazz == clazz3;
        }
        Class<?> clazz4 = primitiveTypeToWrapperMap.get(clazz2);
        return clazz4 != null && clazz.isAssignableFrom(clazz4);
    }

    public static boolean isAssignableValue(Class<?> clazz, Object object) {
        Assert.notNull(clazz, "Type must not be null");
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_CLASS_ARRAY) : EMPTY_CLASS_ARRAY;
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray;
            for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
                if (!ClassUtils.isVisible(clazz3, classLoader)) continue;
                linkedHashSet.add(clazz3);
            }
        }
        return linkedHashSet;
    }

    public static Class<?> determineCommonAncestor(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return clazz2;
        }
        Class<?> clazz3 = clazz;
        do {
            if ((clazz3 = clazz3.getSuperclass()) != null && Object.class != clazz3) continue;
            return null;
        } while (!clazz3.isAssignableFrom(clazz2));
        return clazz3;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    public static String getShortName(String string) {
        Assert.hasLength(string, "Class name must not be empty");
        int n2 = string.lastIndexOf(46);
        int n3 = string.indexOf("$$");
        if (n3 == -1) {
            n3 = string.length();
        }
        String string2 = string.substring(n2 + 1, n3);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethodIfAvailable(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        if (classArray != null) {
            return ClassUtils.getMethodOrNull(clazz, string, classArray);
        }
        Set<Method> set = ClassUtils.findMethodCandidatesByName(clazz, string);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }

    public static Method getInterfaceMethodIfPossible(Method method2, Class<?> clazz) {
        if (!Modifier.isPublic(method2.getModifiers()) || method2.getDeclaringClass().isInterface()) {
            return method2;
        }
        Method method3 = interfaceMethodCache.computeIfAbsent(method2, method -> ClassUtils.findInterfaceMethodIfPossible(method, method.getDeclaringClass(), Object.class));
        if (method3 == method2 && clazz != null) {
            method3 = ClassUtils.findInterfaceMethodIfPossible(method2, clazz, method2.getDeclaringClass());
        }
        return method3;
    }

    private static Method findInterfaceMethodIfPossible(Method method, Class<?> clazz, Class<?> clazz2) {
        for (Class<?> clazz3 = clazz; clazz3 != null && clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            Class<?>[] classArray;
            for (Class<?> clazz4 : classArray = clazz3.getInterfaces()) {
                try {
                    return clazz4.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return method;
    }

    public static Method getStaticMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        try {
            Method method = clazz.getMethod(string, classArray);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getMethodOrNull(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String string) {
        Method[] methodArray;
        HashSet<Method> hashSet = new HashSet<Method>(1);
        for (Method method : methodArray = clazz.getMethods()) {
            if (!string.equals(method.getName())) continue;
            hashSet.add(method);
        }
        return hashSet;
    }

    static {
        interfaceMethodCache = new ConcurrentReferenceHashMap<Method, Method>(256);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> classArray2 : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(classArray2.getValue(), classArray2.getKey());
            ClassUtils.registerCommonClasses(classArray2.getKey());
        }
        HashSet hashSet = new HashSet(32);
        hashSet.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(hashSet, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
        Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassUtils.registerCommonClasses(classArray);
        javaLanguageInterfaces = new HashSet<Class>(Arrays.asList(classArray));
    }
}

